/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PermissionsPageRow;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionPageRowBuilder
implements PageRowBuilder<PageRequest, Map<String, List<String>>> {
    private PageRequest pageRequest;
    private Map<String, List<String>> permissions;

    public List<PermissionsPageRow> build() {
        this.validate();
        int rowMinNumber = this.pageRequest.getStartRowIndex();
        int rowMaxNumber = this.pageRequest.getPageSize() == null ? this.permissions.size() : rowMinNumber + this.pageRequest.getPageSize();
        int resultsSize = this.pageRequest.getPageSize() == null ? this.permissions.size() : this.pageRequest.getPageSize().intValue();
        ArrayList<PermissionsPageRow> rowList = new ArrayList<PermissionsPageRow>(resultsSize);
        Iterator mapItr = this.permissions.keySet().iterator();
        for (int rowNumber = 0; mapItr.hasNext() && rowNumber < rowMaxNumber; ++rowNumber) {
            String userName = (String)mapItr.next();
            if (rowNumber < rowMinNumber) continue;
            List userPermissions = (List)this.permissions.get(userName);
            PermissionsPageRow row = new PermissionsPageRow();
            row.setUserName(userName);
            row.setUserPermissions(userPermissions);
            rowList.add(row);
        }
        return rowList;
    }

    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.permissions == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public PermissionPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public PermissionPageRowBuilder withContent(Map<String, List<String>> permissions) {
        this.permissions = permissions;
        return this;
    }
}

