/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.QueryPageRowCreator;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.RepositoryFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFullTextPageRowBuilder
implements PageRowBuilder<QueryPageRequest, Iterator<AssetItem>> {
    private QueryPageRequest pageRequest;
    private Iterator<AssetItem> iterator;

    public List<QueryPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        PackageFilter filter = new PackageFilter();
        CategoryFilter categoryFilter = new CategoryFilter();
        ArrayList<QueryPageRow> rowList = new ArrayList<QueryPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem assetItem = (AssetItem)this.iterator.next();
            if (!this.checkPackagePermissionHelper((RepositoryFilter)filter, assetItem, RoleType.PACKAGE_READONLY.getName()) && !this.checkCategoryPermissionHelper((RepositoryFilter)categoryFilter, assetItem, RoleType.ANALYST_READ.getName())) continue;
            if (skipped >= startRowIndex) {
                rowList.add(QueryPageRowCreator.makeQueryPageRow((AssetItem)assetItem));
            }
            ++skipped;
        }
        return rowList;
    }

    private boolean checkPackagePermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        return filter.accept((Object)this.getConfigDataHelper(item.getPackage().getUUID()), roleType);
    }

    private boolean checkCategoryPermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        List tempCateList = item.getCategories();
        for (CategoryItem categoryItem : tempCateList) {
            if (!filter.accept((Object)categoryItem.getFullPath(), roleType)) continue;
            return true;
        }
        return false;
    }

    private PackageConfigData getConfigDataHelper(String uuidStr) {
        PackageConfigData data = new PackageConfigData();
        data.setUuid(uuidStr);
        return data;
    }

    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public QueryFullTextPageRowBuilder withPageRequest(QueryPageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public QueryFullTextPageRowBuilder withContent(Iterator<AssetItem> iterator) {
        this.iterator = iterator;
        return this;
    }
}

