/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.decisiontable.ConditionColumnCommand;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.BindingTextBox;
import org.drools.guvnor.client.modeldriven.ui.CEPOperatorsDropdown;
import org.drools.guvnor.client.modeldriven.ui.CEPWindowOperatorsDropdown;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GuidedDTColumnConfig
extends FormStylePopup {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private GuidedDecisionTable52 model;
    private SuggestionCompletionEngine sce;
    private Pattern52 editingPattern;
    private ConditionCol52 editingCol;
    private Label patternLabel = new Label();
    private TextBox fieldLabel = this.getFieldLabel();
    private Label operatorLabel = new Label();
    private ImageButton editField;
    private ImageButton editOp;
    private CEPWindowOperatorsDropdown cwo;
    private TextBox entryPointName;
    private int cepWindowRowIndex;
    private InfoPopup fieldLabelInterpolationInfo = this.getPredicateHint();

    public static HorizontalPanel getDefaultEditor(DTColumnConfig52 editingCol) {
        TextBox defaultValue = new TextBox();
        defaultValue.setText(editingCol.getDefaultValue());
        CheckBox hide = new CheckBox(((Constants)GWT.create(Constants.class)).HideThisColumn());
        hide.setValue(Boolean.valueOf(editingCol.isHideColumn()));
        hide.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        defaultValue.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)defaultValue);
        hp.add((Widget)hide);
        return hp;
    }

    public GuidedDTColumnConfig(SuggestionCompletionEngine sce, GuidedDecisionTable52 model, ConditionColumnCommand refreshGrid, ConditionCol52 col, boolean isNew) {
        this.setModal(false);
        this.model = model;
        this.sce = sce;
        this.editingPattern = model.getPattern(col);
        this.editingCol = new ConditionCol52();
        this.editingCol.setConstraintValueType(col.getConstraintValueType());
        this.editingCol.setFactField(col.getFactField());
        this.editingCol.setFieldType(col.getFieldType());
        this.editingCol.setHeader(col.getHeader());
        this.editingCol.setOperator(col.getOperator());
        this.editingCol.setValueList(col.getValueList());
        this.editingCol.setDefaultValue(col.getDefaultValue());
        this.editingCol.setHideColumn(col.isHideColumn());
        this.editingCol.setParameters(col.getParameters());
        this.editingCol.setWidth(col.getWidth());
        this.setTitle(constants.ConditionColumnConfiguration());
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton(images.edit(), constants.ChooseAnExistingPatternThatThisColumnAddsTo(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pattern.add((Widget)changePattern);
        this.addAttribute(constants.Pattern(), (Widget)pattern);
        RadioButton literal = new RadioButton("constraintValueType", constants.LiteralValue());
        RadioButton formula = new RadioButton("constraintValueType", constants.Formula());
        RadioButton predicate = new RadioButton("constraintValueType", constants.Predicate());
        HorizontalPanel valueTypes = new HorizontalPanel();
        valueTypes.add((Widget)literal);
        valueTypes.add((Widget)formula);
        valueTypes.add((Widget)predicate);
        this.addAttribute(constants.CalculationType(), (Widget)valueTypes);
        switch (this.editingCol.getConstraintValueType()) {
            case 1: {
                literal.setValue(Boolean.valueOf(true));
                break;
            }
            case 3: {
                formula.setValue(Boolean.valueOf(true));
                break;
            }
            case 5: {
                predicate.setValue(Boolean.valueOf(true));
            }
        }
        literal.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        formula.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        predicate.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel field = new HorizontalPanel();
        field.add((Widget)this.fieldLabel);
        field.add((Widget)this.fieldLabelInterpolationInfo);
        this.editField = new ImageButton(images.edit(), images.editDisabled(), constants.EditTheFieldThatThisColumnOperatesOn(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        field.add((Widget)this.editField);
        this.addAttribute(constants.Field(), (Widget)field);
        this.doFieldLabel();
        HorizontalPanel operator = new HorizontalPanel();
        operator.add((Widget)this.operatorLabel);
        this.editOp = new ImageButton(images.edit(), images.editDisabled(), constants.EditTheOperatorThatIsUsedToCompareDataWithThisField(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        operator.add((Widget)this.editOp);
        this.addAttribute(constants.Operator(), (Widget)operator);
        this.doOperatorLabel();
        this.doImageButtons();
        this.cepWindowRowIndex = this.addAttribute(constants.DTLabelOverCEPWindow(), this.createCEPWindowWidget((HasCEPWindow)this.editingPattern));
        this.displayCEPOperators();
        this.entryPointName = new TextBox();
        this.entryPointName.setText(this.editingPattern.getEntryPointName());
        this.entryPointName.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute(constants.DTLabelFromEntryPoint(), (Widget)this.entryPointName);
        TextBox valueList = new TextBox();
        valueList.setText(this.editingCol.getValueList());
        valueList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel vl = new HorizontalPanel();
        vl.add((Widget)valueList);
        vl.add((Widget)new InfoPopup(constants.ValueList(), constants.ValueListsExplanation()));
        this.addAttribute(constants.optionalValueList(), (Widget)vl);
        TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute(constants.ColumnHeaderDescription(), (Widget)header);
        this.addAttribute(constants.DefaultValue(), (Widget)GuidedDTColumnConfig.getDefaultEditor((DTColumnConfig52)this.editingCol));
        Button apply = new Button(constants.ApplyChanges());
        apply.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute("", (Widget)apply);
    }

    private void applyConsTypeChange(int newType) {
        this.editingCol.setConstraintValueType(newType);
        this.doFieldLabel();
        this.doOperatorLabel();
        this.doImageButtons();
    }

    private void doImageButtons() {
        int constraintType = this.editingCol.getConstraintValueType();
        this.editField.setEnabled(constraintType != 5);
        this.editOp.setEnabled(constraintType != 5);
    }

    private boolean checkUnique(String fn, List<Pattern52> patterns) {
        for (Pattern52 p : patterns) {
            if (!p.getBoundName().equals(fn)) continue;
            return false;
        }
        return true;
    }

    private void doFieldLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            if (this.editingCol.getFactField() == null || this.editingCol.getFactField().equals("")) {
                this.fieldLabel.setText(constants.notNeededForPredicate());
            } else {
                this.fieldLabel.setText(this.editingCol.getFactField());
            }
            this.fieldLabelInterpolationInfo.setVisible(true);
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.fieldLabel.setText(constants.pleaseSelectAPatternFirst());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else if (this.nil(this.editingCol.getFactField())) {
            this.fieldLabel.setText(constants.pleaseSelectAField());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else {
            this.fieldLabel.setText(this.editingCol.getFactField());
        }
    }

    private void doOperatorLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            this.operatorLabel.setText(constants.notNeededForPredicate());
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.operatorLabel.setText(constants.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.getFactField())) {
            this.operatorLabel.setText(constants.pleaseChooseAFieldFirst());
        } else if (this.nil(this.editingCol.getOperator())) {
            this.operatorLabel.setText(constants.pleaseSelectAField());
        } else {
            this.operatorLabel.setText(HumanReadable.getOperatorDisplayName((String)this.editingCol.getOperator()));
        }
    }

    private void doPatternLabel() {
        if (this.editingPattern.getFactType() != null) {
            this.patternLabel.setText((this.editingPattern.isNegated() ? constants.negatedPattern() + " " : "") + this.editingPattern.getFactType() + " [" + this.editingPattern.getBoundName() + "]");
        }
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    private TextBox getFieldLabel() {
        TextBox box = new TextBox();
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private InfoPopup getPredicateHint() {
        return new InfoPopup(constants.Predicates(), constants.PredicatesInfo());
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (int i = 0; i < this.model.getConditionPatterns().size(); ++i) {
            Pattern52 p = (Pattern52)this.model.getConditionPatterns().get(i);
            if (vars.contains(p.getBoundName())) continue;
            patterns.addItem((p.isNegated() ? constants.negatedPattern() + " " : "") + p.getFactType() + " [" + p.getBoundName() + "]", p.getFactType() + " " + p.getBoundName() + " " + p.isNegated());
            vars.add(p.getBoundName());
        }
        return patterns;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showOperatorChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(constants.SetTheOperator());
        pop.setModal(false);
        String[] ops = this.sce.getOperatorCompletions(this.editingPattern.getFactType(), this.editingCol.getFactField());
        CEPOperatorsDropdown box = new CEPOperatorsDropdown(ops, (HasParameterizedOperator)this.editingCol);
        if (1 == this.editingCol.getConstraintValueType()) {
            box.addItem(HumanReadable.getOperatorDisplayName((String)"in"), "in");
        }
        box.addItem(constants.noOperator(), "");
        pop.addAttribute(constants.Operator(), (Widget)box);
        Button b = new Button(constants.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private boolean unique(String header) {
        for (Pattern52 p : this.model.getConditionPatterns()) {
            for (ConditionCol52 c : p.getConditions()) {
                if (!c.getHeader().equals(header)) continue;
                return false;
            }
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        FormStylePopup pop = new FormStylePopup();
        Button ok = new Button(constants.OK());
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)pats);
        hp.add((Widget)ok);
        pop.addAttribute(constants.ChooseExistingPatternToAddColumnTo(), (Widget)hp);
        pop.addAttribute("", (Widget)new HTML(constants.ORwithEmphasis()));
        Button createPattern = new Button(constants.CreateNewFactPattern());
        createPattern.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)createPattern);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showFieldChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        String[] fields = this.sce.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, this.editingPattern.getFactType());
        ListBox box = new ListBox();
        for (int i = 0; i < fields.length; ++i) {
            box.addItem(fields[i]);
        }
        pop.addAttribute(constants.Field(), (Widget)box);
        Button b = new Button(constants.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showNewPatternDialog() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(constants.CreateANewFactPattern());
        ListBox types = new ListBox();
        for (int i = 0; i < this.sce.getFactTypes().length; ++i) {
            types.addItem(this.sce.getFactTypes()[i]);
        }
        pop.addAttribute(constants.FactType(), (Widget)types);
        BindingTextBox binding = new BindingTextBox();
        binding.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(constants.Binding(), (Widget)binding);
        CheckBox chkNegated = new CheckBox();
        pop.addAttribute(constants.negatePattern(), (Widget)chkNegated);
        Button ok = new Button(constants.OK());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private Widget createCEPWindowWidget(HasCEPWindow c) {
        HorizontalPanel hp = new HorizontalPanel();
        Label lbl = new Label(constants.OverCEPWindow());
        lbl.setStyleName("paddedLabel");
        hp.add((Widget)lbl);
        this.cwo = new CEPWindowOperatorsDropdown(c);
        this.cwo.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        hp.add((Widget)this.cwo);
        return hp;
    }

    private void displayCEPOperators() {
        boolean isVisible = this.sce.isFactTypeAnEvent(this.editingPattern.getFactType());
        this.setAttributeVisibility(this.cepWindowRowIndex, isVisible);
    }

    static /* synthetic */ ConditionCol52 access$000(GuidedDTColumnConfig x0) {
        return x0.editingCol;
    }

    static /* synthetic */ void access$100(GuidedDTColumnConfig x0, int x1) {
        x0.applyConsTypeChange(x1);
    }

    static /* synthetic */ void access$200(GuidedDTColumnConfig x0) {
        x0.showOperatorChange();
    }

    static /* synthetic */ TextBox access$300(GuidedDTColumnConfig x0) {
        return x0.entryPointName;
    }

    static /* synthetic */ Pattern52 access$400(GuidedDTColumnConfig x0) {
        return x0.editingPattern;
    }

    static /* synthetic */ Constants access$500() {
        return constants;
    }

    static /* synthetic */ boolean access$600(GuidedDTColumnConfig x0, String x1) {
        return x0.unique(x1);
    }

    static /* synthetic */ void access$700(GuidedDTColumnConfig x0) {
        x0.doOperatorLabel();
    }

    static /* synthetic */ Pattern52 access$402(GuidedDTColumnConfig x0, Pattern52 x1) {
        x0.editingPattern = x1;
        return x0.editingPattern;
    }

    static /* synthetic */ GuidedDecisionTable52 access$800(GuidedDTColumnConfig x0) {
        return x0.model;
    }

    static /* synthetic */ CEPWindowOperatorsDropdown access$900(GuidedDTColumnConfig x0) {
        return x0.cwo;
    }

    static /* synthetic */ void access$1000(GuidedDTColumnConfig x0) {
        x0.displayCEPOperators();
    }

    static /* synthetic */ void access$1100(GuidedDTColumnConfig x0) {
        x0.doPatternLabel();
    }

    static /* synthetic */ SuggestionCompletionEngine access$1200(GuidedDTColumnConfig x0) {
        return x0.sce;
    }

    static /* synthetic */ void access$1300(GuidedDTColumnConfig x0) {
        x0.doFieldLabel();
    }

    static /* synthetic */ boolean access$1400(GuidedDTColumnConfig x0, String x1, List x2) {
        return x0.checkUnique(x1, x2);
    }
}

