/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.AuditEventsImages;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.util.PercentageBar;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunnerWidget
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private static AuditEventsImages auditEventsImages = (AuditEventsImages)GWT.create(AuditEventsImages.class);
    FlexTable results = new FlexTable();
    VerticalPanel layout = new VerticalPanel();
    private SimplePanel actions = new SimplePanel();

    public TestRunnerWidget(ScenarioWidget parent, String packageName) {
        Button run = new Button(this.constants.RunScenario());
        run.setTitle(this.constants.RunScenarioTip());
        run.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.actions.add((Widget)run);
        this.layout.add((Widget)this.actions);
        this.initWidget((Widget)this.layout);
    }

    private void showErrors(List<BuilderResultLine> rs) {
        this.results.clear();
        this.results.setVisible(true);
        FlexTable errTable = new FlexTable();
        errTable.setStyleName("build-Results");
        for (int i = 0; i < rs.size(); ++i) {
            int row = i;
            BuilderResultLine res = rs.get(i);
            errTable.setWidget(row, 0, (Widget)new Image(images.error()));
            if (res.getAssetFormat().equals("package")) {
                errTable.setText(row, 1, this.constants.packageConfigurationProblem1() + res.getMessage());
                continue;
            }
            errTable.setText(row, 1, "[" + res.getAssetName() + "] " + res.getMessage());
        }
        ScrollPanel scroll = new ScrollPanel((Widget)errTable);
        scroll.setWidth("100%");
        this.results.setWidget(0, 0, (Widget)scroll);
    }

    private void showResults(ScenarioWidget parent, SingleScenarioResult data) {
        this.results.clear();
        this.results.setVisible(true);
        parent.setScenario(data.result.getScenario());
        parent.setShowResults(true);
        parent.renderEditor();
        int failures = 0;
        int total = 0;
        VerticalPanel resultsDetail = new VerticalPanel();
        for (Fixture fixture : data.result.getScenario().getFixtures()) {
            ExecutionTrace ex;
            if (fixture instanceof VerifyRuleFired) {
                VerifyRuleFired verifyRuleFired = (VerifyRuleFired)fixture;
                HorizontalPanel panel = new HorizontalPanel();
                if (!verifyRuleFired.getSuccessResult().booleanValue()) {
                    panel.add((Widget)new Image(images.warning()));
                    ++failures;
                } else {
                    panel.add((Widget)new Image(images.testPassed()));
                }
                panel.add((Widget)new SmallLabel(verifyRuleFired.getExplanation()));
                resultsDetail.add((Widget)panel);
                ++total;
                continue;
            }
            if (fixture instanceof VerifyFact) {
                VerifyFact verifyFact = (VerifyFact)fixture;
                Iterator fieldIterator = verifyFact.getFieldValues().iterator();
                while (fieldIterator.hasNext()) {
                    ++total;
                    VerifyField verifyField = (VerifyField)fieldIterator.next();
                    HorizontalPanel panel = new HorizontalPanel();
                    if (!verifyField.getSuccessResult().booleanValue()) {
                        panel.add((Widget)new Image(images.warning()));
                        ++failures;
                    } else {
                        panel.add((Widget)new Image(images.testPassed()));
                    }
                    panel.add((Widget)new SmallLabel(verifyField.getExplanation()));
                    resultsDetail.add((Widget)panel);
                }
                continue;
            }
            if (!(fixture instanceof ExecutionTrace) || (ex = (ExecutionTrace)fixture).getNumberOfRulesFired() != (long)data.result.getScenario().getMaxRuleFirings()) continue;
            Window.alert((String)this.constants.MaxRuleFiringsReachedWarning(data.result.getScenario().getMaxRuleFirings()));
        }
        this.results.setWidget(0, 0, (Widget)new SmallLabel(this.constants.Results()));
        this.results.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        if (failures > 0) {
            this.results.setWidget(0, 1, (Widget)new PercentageBar("#CC0000", 150, failures, total));
        } else {
            this.results.setWidget(0, 1, (Widget)new PercentageBar("GREEN", 150, failures, total));
        }
        this.results.setWidget(1, 0, (Widget)new SmallLabel(this.constants.SummaryColon()));
        this.results.getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.results.setWidget(1, 1, (Widget)resultsDetail);
        this.results.setWidget(2, 0, (Widget)new SmallLabel(this.constants.AuditLogColon()));
        Button showExp = new Button(this.constants.ShowEventsButton());
        this.results.setWidget(2, 1, (Widget)showExp);
        showExp.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget doAuditView(List<String[]> auditLog) {
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new HTML("<hr/>"));
        FlexTable g = new FlexTable();
        int row = 0;
        boolean firing = false;
        for (int i = 0; i < auditLog.size(); ++i) {
            String[] lg = auditLog.get(i);
            int id = Integer.parseInt(lg[0]);
            if (id <= 7) {
                if (id <= 3) {
                    if (!firing) {
                        g.setWidget(row, 0, (Widget)this.getEventImage(lg[0]));
                        g.setWidget(row, 1, (Widget)new SmallLabel(lg[1]));
                    } else {
                        g.setWidget(row, 1, this.hz(this.getEventImage(lg[0]), new SmallLabel(lg[1])));
                    }
                    ++row;
                    continue;
                }
                if (id == 6) {
                    firing = true;
                    g.setWidget(row, 0, (Widget)this.getEventImage(lg[0]));
                    g.setWidget(row, 1, (Widget)new SmallLabel("<b>" + lg[1] + "</b>"));
                    ++row;
                    continue;
                }
                if (id == 7) {
                    firing = false;
                    continue;
                }
                g.setWidget(row, 0, (Widget)this.getEventImage(lg[0]));
                g.setWidget(row, 1, (Widget)new SmallLabel("<font color='grey'>" + lg[1] + "</font>"));
                ++row;
                continue;
            }
            g.setWidget(row, 0, (Widget)new Image(auditEventsImages.miscEvent()));
            g.setWidget(row, 1, (Widget)new SmallLabel("<font color='grey'>" + lg[1] + "</font>"));
            ++row;
        }
        vp.add((Widget)g);
        vp.add((Widget)new HTML("<hr/>"));
        return vp;
    }

    private Widget hz(Image image, SmallLabel smallLabel) {
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)image);
        h.add((Widget)smallLabel);
        return h;
    }

    private Image getEventImage(String eventType) {
        int type;
        try {
            type = Integer.parseInt(eventType);
        }
        catch (NumberFormatException e) {
            return new Image(auditEventsImages.miscEvent());
        }
        switch (type) {
            case 1: {
                return new Image(auditEventsImages.image1());
            }
            case 2: {
                return new Image(auditEventsImages.image2());
            }
            case 3: {
                return new Image(auditEventsImages.image3());
            }
            case 4: {
                return new Image(auditEventsImages.image4());
            }
            case 5: {
                return new Image(auditEventsImages.image5());
            }
            case 6: {
                return new Image(auditEventsImages.image6());
            }
            case 7: {
                return new Image(auditEventsImages.image7());
            }
        }
        return new Image(auditEventsImages.miscEvent());
    }

    static /* synthetic */ Constants access$000(TestRunnerWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ SimplePanel access$100(TestRunnerWidget x0) {
        return x0.actions;
    }

    static /* synthetic */ void access$200(TestRunnerWidget x0, List x1) {
        x0.showErrors(x1);
    }

    static /* synthetic */ void access$300(TestRunnerWidget x0, ScenarioWidget x1, SingleScenarioResult x2) {
        x0.showResults(x1, x2);
    }

    static /* synthetic */ Widget access$400(TestRunnerWidget x0, List x1) {
        return x0.doAuditView(x1);
    }
}

