/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.modeldriven.ui.DSLSentenceWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;

public class DSLSentenceWidget
extends RuleModellerWidget {
    private final List<Widget> widgets = new ArrayList();
    private final List<DSLDropDown> dropDownWidgets = new ArrayList();
    private final DSLSentence sentence;
    private final VerticalPanel layout;
    private HorizontalPanel currentRow;
    private boolean readOnly;

    public DSLSentenceWidget(RuleModeller modeller, DSLSentence sentence) {
        this(modeller, sentence, null);
    }

    public DSLSentenceWidget(RuleModeller modeller, DSLSentence sentence, Boolean readOnly) {
        super(modeller);
        this.sentence = sentence;
        this.readOnly = readOnly == null ? false : readOnly;
        this.layout = new VerticalPanel();
        this.currentRow = new HorizontalPanel();
        this.layout.add((Widget)this.currentRow);
        this.layout.setCellWidth((Widget)this.currentRow, "100%");
        this.layout.setWidth("100%");
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.init();
    }

    private void init() {
        this.makeWidgets(this.sentence);
        this.initWidget((Widget)this.layout);
    }

    public void makeWidgets(DSLSentence sentence) {
        String dslDefinition = sentence.getDefinition();
        List dslValues = sentence.getValues();
        int index = 0;
        int startVariable = dslDefinition.indexOf("{");
        ArrayList<Object> lineWidgets = new ArrayList<Object>();
        boolean firstOneIsBracket = dslDefinition.indexOf("{") == 0;
        String startLabel = "";
        if (startVariable > 0) {
            startLabel = dslDefinition.substring(0, startVariable);
        } else if (!firstOneIsBracket) {
            startLabel = dslDefinition;
        }
        Widget label = this.getLabel(startLabel);
        lineWidgets.add(label);
        while (startVariable > 0 || firstOneIsBracket) {
            firstOneIsBracket = false;
            int endVariable = this.getIndexForEndOfVariable(dslDefinition, startVariable);
            String string = dslDefinition.substring(startVariable + 1, endVariable);
            String value = (String)dslValues.get(index);
            Widget varWidget = this.processVariable(string, value);
            lineWidgets.add(varWidget);
            ++index;
            startVariable = dslDefinition.indexOf("{", endVariable);
            String lbl = startVariable > 0 ? dslDefinition.substring(endVariable + 1, startVariable) : dslDefinition.substring(endVariable + 1, dslDefinition.length());
            if (lbl.indexOf("\\n") > -1) {
                String[] lines = lbl.split("\\\\n");
                for (int i = 0; i < lines.length; ++i) {
                    lineWidgets.add(new NewLine(this));
                    lineWidgets.add(this.getLabel(lines[i]));
                }
                continue;
            }
            Widget currLabel = this.getLabel(lbl);
            lineWidgets.add(currLabel);
        }
        for (Widget widget : lineWidgets) {
            this.addWidget(widget);
        }
        this.updateEnumDropDowns();
    }

    private int getIndexForEndOfVariable(String dsl, int start) {
        int end = -1;
        int bracketCount = 0;
        if (start > dsl.length()) {
            return end;
        }
        for (int i = start; i < dsl.length(); ++i) {
            char c = dsl.charAt(i);
            if (c == '{') {
                ++bracketCount;
            }
            if (c != '}' || --bracketCount != 0) continue;
            end = i;
            return end;
        }
        return -1;
    }

    public Widget processVariable(String currVariable, String value) {
        Widget result = null;
        if (currVariable.contains(":")) {
            if (currVariable.contains(":ENUM:")) {
                result = this.getEnumDropdown(currVariable, value);
            } else if (currVariable.contains(":DATE:")) {
                result = this.getDateSelector(currVariable, value);
            } else if (currVariable.contains(":BOOLEAN:")) {
                result = this.getCheckbox(currVariable, value);
            } else {
                String regex = currVariable.substring(currVariable.indexOf(":") + 1, currVariable.length());
                result = this.getBox(value, regex);
            }
        } else {
            result = this.getBox(value, "");
        }
        return result;
    }

    public Widget getEnumDropdown(String variableDef, String value) {
        DSLDropDown resultWidget = new DSLDropDown(this, variableDef, value);
        this.dropDownWidgets.add(resultWidget);
        return resultWidget;
    }

    public Widget getBox(String variableDef, String regex) {
        FieldEditor currentBox = new FieldEditor(this);
        currentBox.setVisibleLength(variableDef.length() + 1);
        currentBox.setText(variableDef);
        currentBox.setRestriction(regex);
        return currentBox;
    }

    public Widget getCheckbox(String variableDef, String value) {
        return new DSLCheckBox(this, variableDef, value);
    }

    public Widget getDateSelector(String variableDef, String value) {
        String[] parts = variableDef.split(":DATE:");
        return new DSLDateSelector(this, value, parts[1]);
    }

    public Widget getLabel(String labelDef) {
        SmallLabel label = new SmallLabel();
        label.setText(labelDef.trim());
        return label;
    }

    private void addWidget(Widget currentBox) {
        if (currentBox instanceof NewLine) {
            this.currentRow = new HorizontalPanel();
            this.layout.add((Widget)this.currentRow);
            this.layout.setCellWidth((Widget)this.currentRow, "100%");
        } else {
            this.currentRow.add(currentBox);
        }
        this.widgets.add(currentBox);
    }

    protected void updateSentence() {
        int iVariable = 0;
        for (Widget wid : this.widgets) {
            if (wid instanceof FieldEditor) {
                FieldEditor editor = (FieldEditor)wid;
                this.sentence.getValues().set(iVariable++, editor.getText().trim());
                continue;
            }
            if (wid instanceof DSLDropDown) {
                DSLDropDown drop = (DSLDropDown)wid;
                this.sentence.getValues().set(iVariable++, drop.getSelectedValue());
                continue;
            }
            if (wid instanceof DSLCheckBox) {
                DSLCheckBox check = (DSLCheckBox)wid;
                this.sentence.getValues().set(iVariable++, check.getCheckedValue());
                continue;
            }
            if (!(wid instanceof DSLDateSelector)) continue;
            DSLDateSelector dateSel = (DSLDateSelector)wid;
            String dateString = dateSel.getDateString();
            this.sentence.getValues().set(iVariable++, dateString);
        }
        this.setModified(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void updateEnumDropDowns() {
        this.updateSentence();
        for (DSLDropDown dd : this.dropDownWidgets) {
            dd.refreshDropDownData();
            this.updateSentence();
        }
    }

    static /* synthetic */ void access$400(DSLSentenceWidget x0) {
        x0.updateEnumDropDowns();
    }

    static /* synthetic */ DSLSentence access$500(DSLSentenceWidget x0) {
        return x0.sentence;
    }
}

