/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.packages.ArtifactEditor;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.MessageWidget;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.RuleDocumentWidget;

public class ArtifactEditor
extends GuvnorEditor {
    private static ArtifactEditorBinder uiBinder = (ArtifactEditorBinder)GWT.create(ArtifactEditorBinder.class);
    @UiField(provided=true)
    final MetaDataWidget metaWidget;
    @UiField(provided=true)
    final RuleDocumentWidget ruleDocumentWidget;
    @UiField
    MessageWidget messageWidget;
    protected Artifact artifact;
    private long lastSaved = System.currentTimeMillis();

    public ArtifactEditor(ClientFactory clientFactory, EventBus eventBus, Artifact artifact) {
        this(clientFactory, eventBus, artifact, false);
    }

    public ArtifactEditor(ClientFactory clientFactory, EventBus eventBus, Artifact artifact, boolean historicalReadOnly) {
        this.artifact = artifact;
        boolean readOnly = historicalReadOnly || artifact.isReadonly();
        this.ruleDocumentWidget = new RuleDocumentWidget(this.artifact, readOnly);
        this.metaWidget = new MetaDataWidget(clientFactory, eventBus, this.artifact, readOnly, this.artifact.getUuid());
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setWidth("100%");
        LoadingPopup.close();
    }

    public boolean isDirty() {
        return System.currentTimeMillis() - this.lastSaved > 3600000L;
    }

    protected boolean hasDirty() {
        return false;
    }

    public void showInfoMessage(String message) {
        this.messageWidget.showMessage(message);
    }
}

