/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.util;

import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.drools.guvnor.client.util.AbstractLazyStackPanelHeader;
import org.drools.guvnor.client.util.LazyStackPanelHeader;
import org.drools.guvnor.client.util.LazyStackPanelRow;
import org.drools.guvnor.client.util.LoadContentCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyStackPanel
extends Composite
implements HasSelectionHandlers<LazyStackPanelRow> {
    private FlexTable flexTable = new FlexTable();
    private int rowIndex = 0;

    public LazyStackPanel() {
        this.initWidget((Widget)this.flexTable);
        this.flexTable.setStyleName("guvnor-lazyStackPanel");
        this.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void add(String headerText, LoadContentCommand contentLoad) {
        this.add(headerText, contentLoad, false);
    }

    public void add(String headerText, LoadContentCommand contentLoad, boolean expanded) {
        LazyStackPanelHeader header = new LazyStackPanelHeader(headerText);
        this.add((AbstractLazyStackPanelHeader)header, contentLoad, expanded);
    }

    public void add(String headerText, ImageResource icon, LoadContentCommand contentLoad) {
        LazyStackPanelHeader header = new LazyStackPanelHeader(headerText, icon);
        this.add((AbstractLazyStackPanelHeader)header, contentLoad, false);
    }

    public void add(AbstractLazyStackPanelHeader header, LoadContentCommand contentLoad) {
        this.add(header, contentLoad, false);
    }

    public void add(AbstractLazyStackPanelHeader header, LoadContentCommand contentLoad, boolean expanded) {
        LazyStackPanelRow row = new LazyStackPanelRow(header, contentLoad);
        header.addOpenHandler((OpenHandler)new /* Unavailable Anonymous Inner Class!! */);
        header.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addHeaderRow(row);
        this.addContentRow(row.getContentPanel());
        if (expanded) {
            header.expand();
        }
    }

    private void addHeaderRow(LazyStackPanelRow row) {
        this.flexTable.setWidget(this.rowIndex, 0, (Widget)row);
        this.flexTable.getFlexCellFormatter().setStyleName(this.rowIndex, 0, "guvnor-LazyStackPanel-row-header");
        ++this.rowIndex;
    }

    private void addContentRow(SimplePanel panel) {
        this.flexTable.setWidget(this.rowIndex++, 0, (Widget)panel);
    }

    private void selectRow(LazyStackPanelRow row) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)row);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<LazyStackPanelRow> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    public void swap(int firstIndex, int secondIndex) {
        Widget firstHeader = this.flexTable.getWidget(firstIndex *= 2, 0);
        Widget firstContent = this.flexTable.getWidget(firstIndex + 1, 0);
        Widget secondHeader = this.flexTable.getWidget(secondIndex *= 2, 0);
        Widget secondContent = this.flexTable.getWidget(secondIndex + 1, 0);
        this.flexTable.setWidget(firstIndex, 0, secondHeader);
        this.flexTable.setWidget(firstIndex + 1, 0, secondContent);
        this.flexTable.setWidget(secondIndex, 0, firstHeader);
        this.flexTable.setWidget(secondIndex + 1, 0, firstContent);
    }

    public Iterator<AbstractLazyStackPanelHeader> getHeaderIterator() {
        ArrayList<AbstractLazyStackPanelHeader> result = new ArrayList<AbstractLazyStackPanelHeader>();
        for (Widget widget : this.flexTable) {
            if (!(widget instanceof LazyStackPanelRow)) continue;
            result.add(((LazyStackPanelRow)widget).getHeader());
        }
        return result.iterator();
    }

    public void remove(int index) {
        this.flexTable.removeRow((index *= 2) + 1);
        this.flexTable.removeRow(index);
    }

    static /* synthetic */ void access$000(LazyStackPanel x0, LazyStackPanelRow x1) {
        x0.selectRow(x1);
    }
}

