/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.util.Discussion;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.RuleAssetPopulator;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.client.rpc.AssetService")
@AutoCreate
public class RepositoryAssetService
implements AssetService {
    @In
    private RulesRepository repository;
    private static final long serialVersionUID = 90111L;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetService.class);
    private final ServiceSecurity serviceSecurity = new ServiceSecurity();
    private final RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();

    @Create
    public void create() {
        this.repositoryAssetOperations.setRulesRepository(this.getRulesRepository());
    }

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
        this.create();
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public RuleAsset loadRuleAsset(String uuid) throws SerializationException {
        long time = System.currentTimeMillis();
        AssetItem item = this.getRulesRepository().loadAssetByUUID(uuid);
        RuleAsset asset = new RuleAssetPopulator().populateFrom(item);
        asset.setMetaData(this.repositoryAssetOperations.populateMetaData(item));
        this.serviceSecurity.checkIsPackageReadOnlyOrAnalystReadOnly(asset);
        PackageItem pkgItem = this.handlePackageItem(item, asset);
        log.debug("Package: " + pkgItem.getName() + ", asset: " + item.getName() + ". Load time taken for asset: " + (System.currentTimeMillis() - time));
        UserInbox.recordOpeningEvent((AssetItem)item);
        return asset;
    }

    private PackageItem handlePackageItem(AssetItem item, RuleAsset asset) throws SerializationException {
        PackageItem packageItem = item.getPackage();
        ContentHandler handler = ContentManager.getHandler((String)asset.getFormat());
        handler.retrieveAssetContent(asset, item);
        asset.setReadonly(asset.getMetaData().isHasSucceedingVersion());
        if (packageItem.isSnapshot()) {
            asset.setReadonly(true);
        }
        return packageItem;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public RuleAsset[] loadRuleAssets(String[] uuids) throws SerializationException {
        return this.loadRuleAssets(Arrays.asList(uuids));
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String checkinVersion(RuleAsset asset) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        log.info("USER:" + this.getCurrentUserName() + " CHECKING IN asset: [" + asset.getName() + "] UUID: [" + asset.getUuid() + "] ");
        return this.repositoryAssetOperations.checkinVersion(asset);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void restoreVersion(String versionUUID, String assetUUID, String comment) {
        this.repositoryAssetOperations.restoreVersion(versionUUID, assetUUID, comment);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadItemHistory(String uuid) throws SerializationException {
        VersionableItem assetItem = this.getRulesRepository().loadItemByUUID(uuid);
        return this.repositoryAssetOperations.loadItemHistory(assetItem);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadAssetHistory(String packageUUID, String assetName) throws SerializationException {
        PackageItem pi = this.getRulesRepository().loadPackageByUUID(packageUUID);
        AssetItem assetItem = pi.loadAsset(assetName);
        this.serviceSecurity.checkSecurityPackageReadOnlyWithPackageUuid(assetItem.getPackage().getUUID());
        return this.repositoryAssetOperations.loadItemHistory((VersionableItem)assetItem);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    @Deprecated
    public TableDataResult loadArchivedAssets(int skip, int numRows) throws SerializationException {
        return this.repositoryAssetOperations.loadArchivedAssets(skip, numRows);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<AdminArchivedPageRow> loadArchivedAssets(PageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryAssetOperations.loadArchivedAssets(request);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult listAssetsWithPackageName(String packageName, String[] formats, int skip, int numRows, String tableConfig) throws SerializationException {
        PackageItem pkg = this.getRulesRepository().loadPackage(packageName);
        return this.listAssets(pkg.getUUID(), formats, skip, numRows, tableConfig);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult listAssets(String packageUuid, String[] formats, int skip, int numRows, String tableConfig) throws SerializationException {
        log.debug("Loading asset list for [" + packageUuid + "]");
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        return this.repositoryAssetOperations.listAssets(packageUuid, formats, skip, numRows, tableConfig);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String copyAsset(String assetUUID, String newPackage, String newName) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(newPackage);
        log.info("USER:" + this.getCurrentUserName() + " COPYING asset: [" + assetUUID + "] to [" + newName + "] in PACKAGE [" + newPackage + "]");
        return this.getRulesRepository().copyAsset(assetUUID, newPackage, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void changeAssetPackage(String uuid, String newPackage, String comment) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(newPackage);
        AssetItem item = this.getRulesRepository().loadAssetByUUID(uuid);
        this.attachmentRemoved(item);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING PACKAGE OF asset: [" + uuid + "] to [" + newPackage + "]");
        this.getRulesRepository().moveRuleItemPackage(newPackage, uuid, comment);
        this.attachmentAdded(item);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void promoteAssetToGlobalArea(String uuid) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName("globalArea");
        AssetItem item = this.getRulesRepository().loadAssetByUUID(uuid);
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(item.getPackageName());
        this.attachmentRemoved(item);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING PACKAGE OF asset: [" + uuid + "] to [ globalArea ]");
        this.getRulesRepository().moveRuleItemPackage("globalArea", uuid, "promote asset to globalArea");
        this.attachmentAdded(item);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String buildAssetSource(RuleAsset asset) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.repositoryAssetOperations.buildAssetSource(asset);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String renameAsset(String uuid, String newName) {
        AssetItem item = this.getRulesRepository().loadAssetByUUID(uuid);
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(item);
        return this.repositoryAssetOperations.renameAsset(uuid, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void archiveAsset(String uuid) {
        this.archiveOrUnarchiveAsset(uuid, true);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult validateAsset(RuleAsset asset) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.repositoryAssetOperations.validateAsset(asset);
    }

    public void unArchiveAsset(String uuid) {
        this.archiveOrUnarchiveAsset(uuid, false);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void archiveAssets(String[] uuids, boolean value) {
        for (String uuid : uuids) {
            this.archiveOrUnarchiveAsset(uuid, value);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeAsset(String uuid) {
        try {
            AssetItem item = this.getRulesRepository().loadAssetByUUID(uuid);
            this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(item.getPackage().getUUID());
            item.remove();
            this.getRulesRepository().save();
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to remove asset.", (Throwable)e);
            throw e;
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeAssets(String[] uuids) {
        for (String uuid : uuids) {
            this.removeAsset(uuid);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<AssetPageRow> findAssetPage(AssetPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryAssetOperations.findAssetPage(request);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<QueryPageRow> quickFindAsset(QueryPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryAssetOperations.quickFindAsset(request);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult quickFindAsset(String searchText, boolean searchArchived, int skip, int numRows) throws SerializationException {
        return this.repositoryAssetOperations.quickFindAsset(searchText, searchArchived, skip, numRows);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void lockAsset(String uuid) {
        this.repositoryAssetOperations.lockAsset(uuid);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void unLockAsset(String uuid) {
        this.repositoryAssetOperations.unLockAsset(uuid);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult queryFullText(String text, boolean seekArchived, int skip, int numRows) throws SerializationException {
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        return this.repositoryAssetOperations.queryFullText(text, seekArchived, skip, numRows);
    }

    RuleAsset[] loadRuleAssets(Collection<String> uuids) throws SerializationException {
        if (uuids == null) {
            return null;
        }
        HashSet<RuleAsset> assets = new HashSet<RuleAsset>();
        for (String uuid : uuids) {
            assets.add(this.loadRuleAsset(uuid));
        }
        return assets.toArray(new RuleAsset[assets.size()]);
    }

    private void archiveOrUnarchiveAsset(String uuid, boolean archive) {
        try {
            AssetItem item = this.getRulesRepository().loadAssetByUUID(uuid);
            this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(item);
            if (item.getPackage().isArchived()) {
                throw new RulesRepositoryException("The package [" + item.getPackageName() + "] that asset [" + item.getName() + "] belongs to is archived. You need to unarchive it first.");
            }
            log.info("USER:" + this.getCurrentUserName() + " ARCHIVING asset: [" + item.getName() + "] UUID: [" + item.getUUID() + "] ");
            try {
                ContentHandler handler = this.getContentHandler(item);
                if (handler instanceof ICanHasAttachment) {
                    ((ICanHasAttachment)handler).onAttachmentRemoved(item);
                }
            }
            catch (IOException e) {
                log.error("Unable to remove asset attachment", (Throwable)e);
            }
            item.archiveItem(archive);
            PackageItem pkg = item.getPackage();
            pkg.updateBinaryUpToDate(false);
            RuleBaseCache.getInstance().remove(pkg.getUUID());
            if (archive) {
                item.checkin("archived");
            } else {
                item.checkin("unarchived");
            }
            this.push("packageChange", pkg.getName());
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to get item format.", (Throwable)e);
            throw e;
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public List<DiscussionRecord> addToDiscussionForAsset(String assetId, String comment) {
        return this.repositoryAssetOperations.addToDiscussionForAsset(assetId, comment);
    }

    @Restrict(value="#{identity.loggedIn}")
    public void clearAllDiscussionsForAsset(String assetId) {
        this.serviceSecurity.checkSecurityIsAdmin();
        this.repositoryAssetOperations.clearAllDiscussionsForAsset(assetId);
    }

    @Restrict(value="#{identity.loggedIn}")
    public List<DiscussionRecord> loadDiscussionForAsset(String assetId) {
        return new Discussion().fromString(this.getRulesRepository().loadAssetByUUID(assetId).getStringProperty("discussion"));
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void changeState(String uuid, String newState) {
        AssetItem asset = this.getRulesRepository().loadAssetByUUID(uuid);
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING ASSET STATUS. Asset name, uuid: " + "[" + asset.getName() + ", " + asset.getUUID() + "]" + " to [" + newState + "]");
        String oldState = asset.getStateDescription();
        asset.updateState(newState);
        this.push("statusChange", oldState);
        this.push("statusChange", newState);
        this.addToDiscussionForAsset(asset.getUUID(), oldState + " -> " + newState);
        this.getRulesRepository().save();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void changePackageState(String uuid, String newState) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(uuid);
        PackageItem pkg = this.getRulesRepository().loadPackageByUUID(uuid);
        log.info("USER:" + this.getCurrentUserName() + " CHANGING Package STATUS. Asset name, uuid: " + "[" + pkg.getName() + ", " + pkg.getUUID() + "]" + " to [" + newState + "]");
        pkg.changeStatus(newState);
        this.getRulesRepository().save();
    }

    @Restrict(value="#{identity.loggedIn}")
    public String getAssetLockerUserName(String uuid) {
        return this.repositoryAssetOperations.getAssetLockerUserName(uuid);
    }

    @Restrict(value="#{identity.loggedIn}")
    public long getAssetCount(AssetPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        return this.repositoryAssetOperations.getAssetCount(request);
    }

    private void push(String messageType, String message) {
        Backchannel.getInstance().publish(new PushResponse(messageType, message));
    }

    private ContentHandler getContentHandler(AssetItem repoAsset) {
        return ContentManager.getHandler((String)repoAsset.getFormat());
    }

    private String getCurrentUserName() {
        return this.getRulesRepository().getSession().getUserID();
    }

    private void attachmentRemoved(AssetItem item) {
        ICanHasAttachment attachmentHandler = null;
        ContentHandler contentHandler = ContentManager.getHandler((String)item.getFormat());
        if (contentHandler instanceof ICanHasAttachment) {
            attachmentHandler = (ICanHasAttachment)contentHandler;
            try {
                attachmentHandler.onAttachmentRemoved(item);
            }
            catch (IOException ioe) {
                log.error("Unable to remove asset attachment", (Throwable)ioe);
            }
        }
    }

    private void attachmentAdded(AssetItem item) {
        ICanHasAttachment attachmentHandler = null;
        ContentHandler contentHandler = ContentManager.getHandler((String)item.getFormat());
        if (contentHandler instanceof ICanHasAttachment) {
            attachmentHandler = (ICanHasAttachment)contentHandler;
            try {
                attachmentHandler.onAttachmentAdded(item);
            }
            catch (IOException ioe) {
                log.error("Unable to remove asset attachment", (Throwable)ioe);
            }
        }
    }
}

