/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.lang.dsl.DSLMappingParseException;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DSLLoader {
    public static List<DSLTokenizedMappingFile> loadDSLMappingFiles(PackageItem packageItem) {
        return DSLLoader.loadDSLMappingFiles((PackageItem)packageItem, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static List<DSLTokenizedMappingFile> loadDSLMappingFiles(PackageItem packageItem, BRMSPackageBuilder.DSLErrorEvent dslErrorEvent) {
        return DSLLoader.loadDSLMappingFiles((Iterator)packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"dsl"}), (BRMSPackageBuilder.DSLErrorEvent)dslErrorEvent);
    }

    static List<DSLTokenizedMappingFile> loadDSLMappingFiles(Iterator<AssetItem> assetItemIterator, BRMSPackageBuilder.DSLErrorEvent dslErrorEvent) {
        ArrayList<DSLTokenizedMappingFile> result = new ArrayList<DSLTokenizedMappingFile>();
        while (assetItemIterator.hasNext()) {
            DSLLoader.addAsset((BRMSPackageBuilder.DSLErrorEvent)dslErrorEvent, result, (AssetItem)assetItemIterator.next());
        }
        return result;
    }

    private static void addAsset(BRMSPackageBuilder.DSLErrorEvent dslErrorEvent, List<DSLTokenizedMappingFile> result, AssetItem assetItem) {
        if (!assetItem.getDisabled()) {
            DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
            try {
                if (file.parseAndLoad((Reader)new StringReader(assetItem.getContent()))) {
                    result.add(file);
                } else {
                    DSLLoader.logErrors((BRMSPackageBuilder.DSLErrorEvent)dslErrorEvent, (AssetItem)assetItem, (DSLTokenizedMappingFile)file);
                }
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
    }

    private static void logErrors(BRMSPackageBuilder.DSLErrorEvent dslErrorEvent, AssetItem assetItem, DSLTokenizedMappingFile file) {
        for (Object o : file.getErrors()) {
            if (o instanceof DSLMappingParseException) {
                DSLMappingParseException dslMappingParseException = (DSLMappingParseException)o;
                dslErrorEvent.recordError(assetItem, "Line " + dslMappingParseException.getLine() + " : " + dslMappingParseException.getMessage());
                continue;
            }
            if (o instanceof Exception) {
                Exception excp = (Exception)o;
                dslErrorEvent.recordError(assetItem, "Exception " + excp.getClass() + " " + excp.getMessage() + " " + excp.getCause());
                continue;
            }
            dslErrorEvent.recordError(assetItem, "Uncategorized error " + o);
        }
    }
}

