/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.WorkflowProcess;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.RuleFlowContentModelBuilder;
import org.drools.guvnor.server.builder.RuleFlowProcessBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.repository.AssetItem;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.ruleflow.core.RuleFlowProcess;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuleFlowHandler
extends ContentHandler
implements ICompilable,
ICanHasAttachment {
    public void retrieveAssetContent(RuleAsset asset, AssetItem item) throws SerializationException {
        RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(item.getContent().getBytes()));
        if (process != null) {
            RuleFlowContentModel content = RuleFlowContentModelBuilder.createModel((RuleFlowProcess)process);
            content.setXml(item.getContent());
            asset.setContent((PortableObject)content);
        } else if (process == null && !"".equals(item.getContent())) {
            asset.setContent((PortableObject)new RuleFlowContentModel());
            ((RuleFlowContentModel)asset.getContent()).setXml(item.getContent());
        }
    }

    protected RuleFlowProcess readProcess(InputStream is) {
        RuleFlowProcess process = null;
        try {
            InputStreamReader reader = new InputStreamReader(is);
            PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
            XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules(), RuleFlowHandler.getClassLoader());
            try {
                process = (RuleFlowProcess)xmlReader.read((Reader)reader);
            }
            catch (Exception e) {
                reader.close();
                throw new Exception("Unable to read rule flow XML.");
            }
            reader.close();
        }
        catch (Exception e) {
            return null;
        }
        return process;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleFlowContentModel content = (RuleFlowContentModel)asset.getContent();
        if (content != null && content.getXml() != null) {
            RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(content.getXml().getBytes()));
            if (process != null) {
                RuleFlowProcessBuilder.updateProcess((RuleFlowProcess)process, (Collection)content.getNodes());
                XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
                String out = dumper.dump((WorkflowProcess)process);
                repoAsset.updateContent(out);
            } else {
                repoAsset.updateContent(content.getXml());
            }
        }
    }

    public void onAttachmentAdded(AssetItem item) {
        String originalPackageName;
        String packageName;
        RuleFlowProcess process;
        String content = item.getContent();
        if (content != null && !content.equals("") && (process = this.readProcess((InputStream)new ByteArrayInputStream(content.getBytes()))) != null && !(packageName = item.getPackageName()).equals(originalPackageName = process.getPackageName())) {
            process.setPackageName(packageName);
            XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)process);
            item.updateContent(out);
            item.checkin("Changed rule flow package from " + originalPackageName + " to " + packageName);
        }
    }

    public void onAttachmentRemoved(AssetItem item) throws IOException {
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        InputStream ins = asset.getBinaryContentAttachment();
        if (ins != null) {
            builder.addRuleFlow((Reader)new InputStreamReader(asset.getBinaryContentAttachment()));
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = RuleFlowHandler.class.getClassLoader();
        }
        return cl;
    }
}

