/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.repository.MigrateRepository;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryConfigurator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.events.CheckinEvent;
import org.drools.repository.events.StorageEventManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Scope(value=ScopeType.APPLICATION)
@Startup
@Name(value="repositoryConfiguration")
public class RepositoryStartupService {
    private static final Logger log = LoggerFactory.getLogger(RepositoryStartupService.class);
    private static final String ADMIN = "admin";
    private static final String ADMIN_USER_PROPERTY = "org.drools.repository.admin.username";
    private static final String ADMIN_PASSWORD_PROPERTY = "org.drools.repository.admin.password";
    private static final String MAILMAN = "mailman";
    private static final String MAILMAN_USER_PROPERTY = "org.drools.repository.mailman.username";
    private static final String MAILMAN_PASSWORD_PROPERTY = "org.drools.repository.mailman.password";
    private static final String SECURE_PASSWORDS_PROPERTY = "org.drools.repository.secure.passwords";
    private RulesRepositoryConfigurator configurator;
    final Map<String, String> properties = new HashMap();
    Repository repository;
    private Session sessionForSetup;
    private RulesRepository mailmanSession;

    public Repository getRepositoryInstance() {
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.properties);
            this.configurator = RulesRepositoryConfigurator.getInstance((Properties)properties);
            this.repository = this.configurator.getJCRRepository();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.repository;
    }

    @Create
    public void create() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.repository = this.getRepositoryInstance();
        String username = "admin";
        if (this.properties.containsKey("org.drools.repository.admin.username")) {
            username = (String)this.properties.get("org.drools.repository.admin.username");
        }
        String password = "password";
        if (this.properties.containsKey("org.drools.repository.admin.password")) {
            password = (String)this.properties.get("org.drools.repository.admin.password");
            if ("true".equalsIgnoreCase((String)this.properties.get("org.drools.repository.secure.passwords"))) {
                password = RepositoryStartupService.decode((String)password);
            }
        } else {
            log.debug("Could not find property org.drools.repository.admin.password for user admin");
        }
        this.sessionForSetup = this.newSession(username, password);
        this.create(this.sessionForSetup);
        this.startMailboxService();
        RepositoryStartupService.registerCheckinListener();
    }

    public static void registerCheckinListener() {
        System.out.println("Registering check-in listener");
        StorageEventManager.registerCheckinEvent((CheckinEvent)new /* Unavailable Anonymous Inner Class!! */);
        System.out.println("Check-in listener up");
    }

    public static void removeListeners() {
        System.out.println("Removing all listeners...");
        StorageEventManager.removeListeners();
        System.out.println("Listeners removed...");
    }

    private void startMailboxService() {
        String username = "mailman";
        if (this.properties.containsKey("org.drools.repository.mailman.username")) {
            username = (String)this.properties.get("org.drools.repository.mailman.username");
        }
        String password = "password";
        if (this.properties.containsKey("org.drools.repository.mailman.password")) {
            password = (String)this.properties.get("org.drools.repository.mailman.password");
            if ("true".equalsIgnoreCase((String)this.properties.get("org.drools.repository.secure.passwords"))) {
                password = RepositoryStartupService.decode((String)password);
            }
        } else {
            log.debug("Could not find property org.drools.repository.mailman.password for user mailman");
        }
        this.mailmanSession = new RulesRepository(this.newSession(username, password));
        MailboxService.getInstance().init(this.mailmanSession);
        MailboxService.getInstance().wakeUp();
    }

    void create(Session sessionForSetup) {
        RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(sessionForSetup);
        if (!admin.isRepositoryInitialized()) {
            try {
                this.configurator.setupRepository(sessionForSetup);
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        RulesRepository repo = new RulesRepository(sessionForSetup);
        try {
            if (MigrateRepository.needsRuleflowMigration((RulesRepository)repo)) {
                MigrateRepository.migrateRuleflows((RulesRepository)repo);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    @Destroy
    public void close() {
        this.sessionForSetup.logout();
        MailboxService.getInstance().stop();
        this.mailmanSession.logout();
    }

    public void setHomeDirectory(String home) {
        if (home != null) {
            this.properties.put("repository.root.directory", home);
        }
    }

    public void setRepositoryConfigurator(String clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (clazz != null) {
            this.properties.put("org.drools.repository.configurator", clazz);
        }
    }

    public Session newSession(String userName) {
        try {
            return this.configurator.login(userName);
        }
        catch (LoginException e) {
            throw new RulesRepositoryException("Unable to login to JCR backend.");
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    public Session newSession(String userName, String password) {
        try {
            return this.configurator.login(userName, password);
        }
        catch (LoginException e) {
            throw new RulesRepositoryException("UserName: [ " + userName + "] Unable to login to JCR backend.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    private static String decode(String secret) {
        String decodedPassword = secret;
        try {
            byte[] kbytes = "jaas is the way".getBytes();
            SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
            BigInteger n = new BigInteger(secret, 16);
            byte[] encoding = n.toByteArray();
            if (encoding.length % 8 != 0) {
                int length = encoding.length;
                int newLength = (length / 8 + 1) * 8;
                int pad = newLength - length;
                byte[] old = encoding;
                encoding = new byte[newLength];
                for (int i = old.length - 1; i >= 0; --i) {
                    encoding[i + pad] = old[i];
                }
            }
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, key);
            byte[] decode = cipher.doFinal(encoding);
            decodedPassword = new String(decode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return decodedPassword;
    }
}

