/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepositoryException;

public class RowLoader {
    private String[] headers;
    private String[] headerTypes;
    List<Method> extractors;

    public String[] getHeaders() {
        return this.headers;
    }

    public String[] getHeaderTypes() {
        return this.headerTypes;
    }

    public String[] getRow(AssetItem item) {
        String[] row = new String[this.headers.length];
        for (int i = 0; i < row.length; ++i) {
            Method meth = (Method)this.extractors.get(i);
            try {
                Object val = meth.invoke((Object)item, (Object[])null);
                if (val instanceof String) {
                    String s = (String)val;
                    if (s.length() > 64) {
                        s = s.substring(0, 61) + "...";
                    }
                    row[i] = s;
                    continue;
                }
                if (val instanceof Calendar) {
                    row[i] = Long.toString(((Calendar)val).getTime().getTime());
                    continue;
                }
                row[i] = val.toString();
                continue;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RulesRepositoryException((Throwable)e);
            }
        }
        return row;
    }

    public RowLoader(String resourcename) {
        InputStream in = RowLoader.class.getResourceAsStream("/" + resourcename + ".properties");
        if (in == null) {
            throw new IllegalStateException("can't find resource name: /" + resourcename + ".properties");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> fieldTypes = new ArrayList<String>();
        this.extractors = new ArrayList();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().equals("")) continue;
                StringTokenizer tok = new StringTokenizer(line, "=");
                String field = tok.nextToken();
                String method = tok.nextToken();
                fields.add(field);
                Method meth = AssetItem.class.getMethod(method, new Class[0]);
                this.extractors.add(meth);
                fieldTypes.add(meth.getGenericReturnType().toString());
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException((Throwable)e);
        }
        finally {
            this.closeStream(reader);
        }
        this.headers = fields.toArray(new String[fields.size()]);
        this.headerTypes = fieldTypes.toArray(new String[fieldTypes.size()]);
    }

    private void closeStream(BufferedReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

