/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.PopupTitleBar;

public abstract class Popup
extends PopupPanel {
    private boolean dragged = false;
    private int dragStartX;
    private int dragStartY;
    private Command afterShowEvent;
    private boolean fixedLocation = false;

    public Popup() {
        this.setGlassEnabled(true);
    }

    public void setAfterShow(Command afterShowEvent) {
        this.afterShowEvent = afterShowEvent;
    }

    public void show() {
        if (this.afterShowEvent != null) {
            this.afterShowEvent.execute();
        }
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setHorizontalAlignment(VerticalPanel.ALIGN_RIGHT);
        PopupTitleBar titleBar = new PopupTitleBar(this.getTitle());
        titleBar.closeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        titleBar.addMouseDownHandler((MouseDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        titleBar.addMouseMoveHandler((MouseMoveHandler)new /* Unavailable Anonymous Inner Class!! */);
        titleBar.addMouseUpHandler((MouseUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        verticalPanel.add((Widget)titleBar);
        Widget content = this.getContent();
        content.setWidth("100%");
        verticalPanel.add(content);
        this.add((Widget)verticalPanel);
        this.add((Widget)this.createKeyListeningFocusPanel(verticalPanel));
        super.show();
        this.focusFirstWidget(content);
        if (!this.fixedLocation) {
            this.center();
        }
    }

    private FocusPanel createKeyListeningFocusPanel(VerticalPanel verticalPanel) {
        FocusPanel focusPanel = new FocusPanel((Widget)verticalPanel);
        focusPanel.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        focusPanel.setStyleName("");
        focusPanel.setFocus(true);
        focusPanel.setWidth("100%");
        return focusPanel;
    }

    private void focusFirstWidget(Widget content) {
        FormStyleLayout fsl;
        Widget ow;
        if (content instanceof FormStyleLayout && (ow = (fsl = (FormStyleLayout)content).getWidget()) instanceof HasWidgets) {
            this.focusFirstWidget((HasWidgets)ow);
        }
    }

    private boolean focusFirstWidget(HasWidgets container) {
        boolean bFocused = false;
        Iterator iw = container.iterator();
        while (!bFocused && iw.hasNext()) {
            Widget w = (Widget)iw.next();
            if (w instanceof HasWidgets) {
                bFocused = this.focusFirstWidget((HasWidgets)w);
                continue;
            }
            if (w instanceof Focusable) {
                ((Focusable)w).setFocus(true);
                bFocused = true;
                break;
            }
            if (!(w instanceof FocusWidget)) continue;
            ((FocusWidget)w).setFocus(true);
            bFocused = true;
            break;
        }
        return bFocused;
    }

    public void setPopupPosition(int left, int top) {
        super.setPopupPosition(left, top);
        if (left != 0 && top != 0) {
            this.fixedLocation = true;
        }
    }

    public abstract Widget getContent();

    static /* synthetic */ boolean access$002(Popup x0, boolean x1) {
        x0.dragged = x1;
        return x0.dragged;
    }

    static /* synthetic */ int access$102(Popup x0, int x1) {
        x0.dragStartX = x1;
        return x0.dragStartX;
    }

    static /* synthetic */ int access$202(Popup x0, int x1) {
        x0.dragStartY = x1;
        return x0.dragStartY;
    }

    static /* synthetic */ boolean access$000(Popup x0) {
        return x0.dragged;
    }

    static /* synthetic */ int access$100(Popup x0) {
        return x0.dragStartX;
    }

    static /* synthetic */ int access$200(Popup x0) {
        return x0.dragStartY;
    }
}

