/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.ResettableEventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceChangeEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.MultiActivityManager;
import org.drools.guvnor.client.explorer.navigation.CloseAllPlacesEvent;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.util.ActivityMapper;
import org.drools.guvnor.client.util.TabbedPanel;

public class MultiActivityManager
implements PlaceChangeEvent.Handler,
ClosePlaceEvent.Handler,
CloseAllPlacesEvent.Handler {
    private final ActivityMapper activityMapper;
    private TabbedPanel tabbedPanel;
    private final EventBus eventBus;
    private final Map<Place, Pair> activeActivities = new HashMap();

    public MultiActivityManager(ActivityMapper activityMapper, EventBus eventBus) {
        this.activityMapper = activityMapper;
        this.eventBus = eventBus;
        eventBus.addHandler(PlaceChangeEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(ClosePlaceEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(CloseAllPlacesEvent.TYPE, (EventHandler)this);
    }

    public void setTabbedPanel(TabbedPanel tabbedPanel) {
        if (this.tabbedPanel != null) {
            throw new IllegalStateException(TabbedPanel.class.getName() + " can only be set once.");
        }
        this.tabbedPanel = tabbedPanel;
    }

    public void onPlaceChange(PlaceChangeEvent event) {
        if (this.tabbedPanel == null) {
            throw new IllegalStateException(TabbedPanel.class.getName() + " is not set for " + MultiActivityManager.class.getName());
        }
        if (this.isActivityAlreadyActive(event.getNewPlace())) {
            this.showExistingActivity(event.getNewPlace());
        } else if (this.ifPlaceExists(event)) {
            this.startNewActivity(event.getNewPlace());
        }
    }

    private void showExistingActivity(Place token) {
        this.tabbedPanel.show(token);
    }

    private boolean isActivityAlreadyActive(Place token) {
        return this.activeActivities.keySet().contains(token);
    }

    private void startNewActivity(Place newPlace) {
        Activity activity = this.activityMapper.getActivity(newPlace);
        ResettableEventBus resettableEventBus = new ResettableEventBus(this.eventBus);
        this.activeActivities.put(newPlace, new Pair(this, activity, resettableEventBus));
        activity.start((AcceptItem)new /* Unavailable Anonymous Inner Class!! */, (EventBus)resettableEventBus);
    }

    private boolean ifPlaceExists(PlaceChangeEvent event) {
        return !event.getNewPlace().equals(Place.NOWHERE);
    }

    public void onClosePlace(ClosePlaceEvent closePlaceEvent) {
        Pair pair = (Pair)this.activeActivities.get(closePlaceEvent.getPlace());
        if (pair != null && pair.getActivity().mayStop()) {
            pair.getActivity().onStop();
            pair.getResettableEventBus().removeHandlers();
            this.activeActivities.remove(closePlaceEvent.getPlace());
            this.tabbedPanel.close(closePlaceEvent.getPlace());
        }
    }

    public void onCloseAllPlaces(CloseAllPlacesEvent event) {
        HashSet places = new HashSet();
        places.addAll(this.activeActivities.keySet());
        for (Place place : places) {
            this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent(place));
        }
    }

    static /* synthetic */ TabbedPanel access$000(MultiActivityManager x0) {
        return x0.tabbedPanel;
    }
}

