/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.drools.ClockType;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.event.AgendaEventListener;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PackageService;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rpc.ScenarioRunResult;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageResponse;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryPackageOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.AuditLogReporter;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.testframework.RuleCoverageListener;
import org.drools.testframework.ScenarioRunner;
import org.drools.util.CompositeClassLoader;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.client.rpc.PackageService")
@AutoCreate
public class RepositoryPackageService
implements PackageService {
    @In
    private RulesRepository repository;
    private static final long serialVersionUID = 901123L;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetService.class);
    private final ServiceSecurity serviceSecurity = new ServiceSecurity();
    private final RepositoryPackageOperations repositoryPackageOperations = new RepositoryPackageOperations();
    private final RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();

    @Create
    public void create() {
        this.repositoryPackageOperations.setRulesRepository(this.getRulesRepository());
        this.repositoryAssetOperations.setRulesRepository(this.getRulesRepository());
    }

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
        this.create();
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listPackages() {
        return this.listPackages(null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listPackages(String workspace) {
        PackageFilter pf = new PackageFilter();
        return this.repositoryPackageOperations.listPackages(false, workspace, (RepositoryFilter)pf);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listArchivedPackages() {
        return this.listArchivedPackages(null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listArchivedPackages(String workspace) {
        return this.repositoryPackageOperations.listPackages(true, workspace, (RepositoryFilter)new PackageFilter());
    }

    public PackageConfigData loadGlobalPackage() {
        return this.repositoryPackageOperations.loadGlobalPackage();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void rebuildPackages() throws SerializationException {
        PackageIterator pkit = this.getRulesRepository().listPackages();
        StringBuilder errs = new StringBuilder();
        while (pkit.hasNext()) {
            PackageItem pkg = (PackageItem)pkit.next();
            try {
                BuilderResult builderResult = this.buildPackage(pkg.getUUID(), true);
                if (builderResult == null) continue;
                errs.append("Unable to build package name [").append(pkg.getName()).append("]\n");
                StringBuilder buf = this.createStringBuilderFrom(builderResult);
                log.warn(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("An error occurred building package [" + pkg.getName() + "]\n");
                errs.append("An error occurred building package [").append(pkg.getName()).append("]\n");
            }
        }
    }

    private StringBuilder createStringBuilderFrom(BuilderResult res) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < res.getLines().size(); ++i) {
            buf.append(((BuilderResultLine)res.getLines().get(i)).toString());
            buf.append('\n');
        }
        return buf;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String buildPackageSource(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(packageUUID);
        return this.repositoryPackageOperations.buildPackageSource(packageUUID);
    }

    @WebRemote
    public String copyPackage(String sourcePackageName, String destPackageName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryPackageOperations.copyPackage(sourcePackageName, destPackageName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removePackage(String uuid) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageUuid(uuid);
        this.repositoryPackageOperations.removePackage(uuid);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String renamePackage(String uuid, String newName) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageUuid(uuid);
        return this.repositoryPackageOperations.renamePackage(uuid, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public byte[] exportPackages(String packageName) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(packageName);
        return this.repositoryPackageOperations.exportPackages(packageName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void importPackages(byte[] byteArray, boolean importAsNew) {
        this.repositoryPackageOperations.importPackages(byteArray, importAsNew);
    }

    @WebRemote
    public String createPackage(String name, String description, String format) throws RulesRepositoryException {
        return this.repositoryPackageOperations.createPackage(name, description, format);
    }

    @WebRemote
    public String createPackage(String name, String description, String format, String[] workspace) throws RulesRepositoryException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryPackageOperations.createPackage(name, description, format, workspace);
    }

    @WebRemote
    public String createSubPackage(String name, String description, String parentNode) throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryPackageOperations.createSubPackage(name, description, parentNode);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData loadPackageConfig(String uuid) {
        PackageItem packageItem = this.getRulesRepository().loadPackageByUUID(uuid);
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName(packageItem.getName());
        return this.repositoryPackageOperations.loadPackageConfig(packageItem);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public ValidatedResponse validatePackageConfiguration(PackageConfigData data) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(data.getUuid());
        return this.repositoryPackageOperations.validatePackageConfiguration(data);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void savePackage(PackageConfigData data) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(data.getUuid());
        this.repositoryPackageOperations.savePackage(data);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult buildPackage(String packageUUID, boolean force) throws SerializationException {
        return this.buildPackage(packageUUID, force, null, null, null, false, null, null, false, null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult buildPackage(String packageUUID, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelectorName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(packageUUID);
        return this.repositoryPackageOperations.buildPackage(packageUUID, force, buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelectorName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void createPackageSnapshot(String packageName, String snapshotName, boolean replaceExisting, String comment) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(packageName);
        this.repositoryPackageOperations.createPackageSnapshot(packageName, snapshotName, replaceExisting, comment);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void copyOrRemoveSnapshot(String packageName, String snapshotName, boolean delete, String newSnapshotName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(packageName);
        this.repositoryPackageOperations.copyOrRemoveSnapshot(packageName, snapshotName, delete, newSnapshotName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listRulesInPackage(String packageName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName(packageName);
        return this.repositoryPackageOperations.listRulesInPackage(packageName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listImagesInPackage(String packageName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName(packageName);
        return this.repositoryPackageOperations.listImagesInPackage(packageName);
    }

    @WebRemote
    public void rebuildSnapshots() throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        PackageIterator pkit = this.getRulesRepository().listPackages();
        while (pkit.hasNext()) {
            String[] snaps;
            PackageItem pkg = (PackageItem)pkit.next();
            for (String snapName : snaps = this.getRulesRepository().listPackageSnapshots(pkg.getName())) {
                PackageItem snap = this.getRulesRepository().loadPackageSnapshot(pkg.getName(), snapName);
                BuilderResult builderResult = this.buildPackage(snap.getUUID(), true);
                if (!builderResult.hasLines()) continue;
                StringBuilder stringBuilder = this.createStringBuilderFrom(builderResult);
                throw new DetailedSerializationException("Unable to rebuild snapshot [" + snapName, stringBuilder.toString() + "]");
            }
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SnapshotInfo[] listSnapshots(String packageName) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(packageName);
        String[] snaps = this.getRulesRepository().listPackageSnapshots(packageName);
        SnapshotInfo[] snapshotInfos = new SnapshotInfo[snaps.length];
        for (int i = 0; i < snaps.length; ++i) {
            PackageItem packageItem = this.getRulesRepository().loadPackageSnapshot(packageName, snaps[i]);
            snapshotInfos[i] = this.packageItemToSnapshotItem(snaps[i], packageItem);
        }
        return snapshotInfos;
    }

    @Restrict(value="#{identity.loggedIn}")
    public SnapshotInfo loadSnapshotInfo(String packageName, String snapshotName) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(packageName);
        return this.packageItemToSnapshotItem(snapshotName, this.getRulesRepository().loadPackageSnapshot(packageName, snapshotName));
    }

    private SnapshotInfo packageItemToSnapshotItem(String snapshotName, PackageItem packageItem) {
        SnapshotInfo snapshotInfo = new SnapshotInfo();
        snapshotInfo.setComment(packageItem.getCheckinComment());
        snapshotInfo.setName(snapshotName);
        snapshotInfo.setUuid(packageItem.getUUID());
        return snapshotInfo;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listTypesInPackage(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityPackageReadOnlyWithPackageUuid(packageUUID);
        PackageItem pkg = this.getRulesRepository().loadPackageByUUID(packageUUID);
        ArrayList res = new ArrayList();
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"jar", "model.drl"});
        JarInputStream jis = null;
        try {
            String[] asset;
            while (it.hasNext()) {
                asset = it.next();
                if (asset.isArchived()) continue;
                if (asset.getFormat().equals("jar")) {
                    jis = this.typesForModel(res, (AssetItem)asset);
                    continue;
                }
                this.typesForOthers(res, (AssetItem)asset);
            }
            asset = res.toArray(new String[res.size()]);
            return asset;
        }
        catch (IOException e) {
            log.error("Unable to read the jar files in the package: " + e.getMessage());
            throw new DetailedSerializationException("Unable to read the jar files in the package.", e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(jis);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void updateDependency(String uuid, String dependencyPath) {
        PackageItem item = this.getRulesRepository().loadPackageByUUID(uuid);
        item.updateDependency(dependencyPath);
        item.checkin("Update dependency");
    }

    public String[] getDependencies(String uuid) {
        PackageItem item = this.getRulesRepository().loadPackageByUUID(uuid);
        return item.getDependencies();
    }

    private JarInputStream typesForModel(List<String> res, AssetItem asset) throws IOException {
        JarInputStream jis = new JarInputStream(asset.getBinaryContentAttachment());
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            res.add(ModelContentHandler.convertPathToName((String)entry.getName()));
        }
        return jis;
    }

    private void typesForOthers(List<String> res, AssetItem asset) {
        DrlParser parser = new DrlParser();
        try {
            PackageDescr desc = parser.parse(asset.getContent());
            List types = desc.getTypeDeclarations();
            for (TypeDeclarationDescr typeDeclarationDescr : types) {
                res.add(typeDeclarationDescr.getTypeName());
            }
        }
        catch (DroolsParserException e) {
            log.error("An error occurred parsing rule: " + e.getMessage());
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public void installSampleRepository() throws SerializationException {
        this.getRulesRepository().importRepository(this.getClass().getResourceAsStream("/mortgage-sample-repository.xml"));
        this.rebuildPackages();
        this.rebuildSnapshots();
    }

    public SnapshotDiffs compareSnapshots(String packageName, String firstSnapshotName, String secondSnapshotName) {
        return this.repositoryPackageOperations.compareSnapshots(packageName, firstSnapshotName, secondSnapshotName);
    }

    public SnapshotComparisonPageResponse compareSnapshots(SnapshotComparisonPageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryPackageOperations.compareSnapshots(request);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SingleScenarioResult runScenario(String packageName, Scenario scenario) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(packageName);
        return this.runScenario(packageName, scenario, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleScenarioResult runScenario(String packageName, Scenario scenario, RuleCoverageListener coverage) throws SerializationException {
        SingleScenarioResult result;
        block7: {
            PackageItem item = this.getRulesRepository().loadPackage(packageName);
            result = null;
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                RuleBase rb = this.loadCacheRuleBase(item);
                CompositeClassLoader cl = ((InternalRuleBase)RuleBaseCache.getInstance().get(item.getUUID())).getRootClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                result = this.runScenario(scenario, item, (ClassLoader)cl, rb, coverage);
            }
            catch (Exception e) {
                if (e instanceof DetailedSerializationException) {
                    DetailedSerializationException err = (DetailedSerializationException)((Object)e);
                    result = new SingleScenarioResult();
                    if (err.getErrs() != null) {
                        result.result = new ScenarioRunResult(err.getErrs(), null);
                        break block7;
                    }
                    throw err;
                }
                throw new DetailedSerializationException("Unable to run the scenario.", e.getMessage());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        return result;
    }

    private RuleBase loadCacheRuleBase(PackageItem packageItem) throws DetailedSerializationException {
        RuleBase rb = null;
        if (packageItem.isBinaryUpToDate() && RuleBaseCache.getInstance().contains(packageItem.getUUID())) {
            rb = RuleBaseCache.getInstance().get(packageItem.getUUID());
        } else {
            ClassLoaderBuilder classLoaderBuilder = new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"}));
            MapBackedClassLoader buildCl = classLoaderBuilder.buildClassLoader();
            if (packageItem.isBinaryUpToDate()) {
                rb = this.loadRuleBase(packageItem, (ClassLoader)buildCl);
                RuleBaseCache.getInstance().put(packageItem.getUUID(), rb);
            } else {
                BuilderResult result = this.repositoryPackageOperations.buildPackage(packageItem, false);
                if (result == null || result.getLines().size() == 0) {
                    rb = this.loadRuleBase(packageItem, (ClassLoader)buildCl);
                    RuleBaseCache.getInstance().put(packageItem.getUUID(), rb);
                } else {
                    throw new DetailedSerializationException("Build error", result.getLines());
                }
            }
        }
        return rb;
    }

    private RuleBase loadRuleBase(PackageItem item, ClassLoader cl) throws DetailedSerializationException {
        try {
            return this.deserKnowledgebase(item, cl);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load rule base.", (Throwable)e);
            throw new DetailedSerializationException("A required class was not found.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Unable to load rule base.", (Throwable)e);
            log.info("...but trying to rebuild binaries...");
            try {
                BuilderResult res = this.repositoryPackageOperations.buildPackage(item, true);
                if (res != null && res.getLines().size() > 0) {
                    log.error("There were errors when rebuilding the knowledgebase.");
                    throw new DetailedSerializationException("There were errors when rebuilding the knowledgebase.", "");
                }
            }
            catch (Exception e1) {
                log.error("Unable to rebuild the rulebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to rebuild the rulebase.", e.getMessage());
            }
            try {
                return this.deserKnowledgebase(item, cl);
            }
            catch (Exception e2) {
                log.error("Unable to reload knowledgebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to reload knowledgebase.", e.getMessage());
            }
        }
    }

    private RuleBase deserKnowledgebase(PackageItem item, ClassLoader classloader) throws IOException, ClassNotFoundException {
        RuleBase rulebase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)new RuleBaseConfiguration(new ClassLoader[]{classloader}));
        Package bin = (Package)DroolsStreamUtils.streamIn((byte[])item.getCompiledPackageBytes(), (ClassLoader)classloader);
        rulebase.addPackage(bin);
        return rulebase;
    }

    private SingleScenarioResult runScenario(Scenario scenario, PackageItem item, ClassLoader cl, RuleBase rulebase, RuleCoverageListener coverage) throws DetailedSerializationException {
        Package bin = rulebase.getPackages()[0];
        Set imps = bin.getImports().keySet();
        HashSet allImps = new HashSet(imps);
        if (bin.getGlobals() != null) {
            for (String o : bin.getGlobals().keySet()) {
                allImps.add(bin.getGlobals().get(o));
            }
        }
        allImps.add(bin.getName() + ".*");
        ClassTypeResolver classTypeResolver = new ClassTypeResolver(allImps, cl);
        SessionConfiguration sessionConfiguration = new SessionConfiguration();
        sessionConfiguration.setClockType(ClockType.PSEUDO_CLOCK);
        sessionConfiguration.setKeepReference(false);
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)rulebase.newStatefulSession(sessionConfiguration, null);
        if (coverage != null) {
            workingMemory.addEventListener((AgendaEventListener)coverage);
        }
        try {
            AuditLogReporter logger = new AuditLogReporter((WorkingMemory)workingMemory);
            new ScenarioRunner(scenario, (TypeResolver)classTypeResolver, workingMemory);
            SingleScenarioResult singleScenarioresult = new SingleScenarioResult();
            singleScenarioresult.auditLog = logger.buildReport();
            singleScenarioresult.result = new ScenarioRunResult(null, scenario);
            return singleScenarioresult;
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load a required class.", (Throwable)e);
            throw new DetailedSerializationException("Unable to load a required class.", e.getMessage());
        }
        catch (ConsequenceException e) {
            String messageShort = "There was an error executing the consequence of rule [" + e.getRule().getName() + "]";
            String messageLong = e.getMessage();
            if (e.getCause() != null) {
                messageLong = messageLong + "\nCAUSED BY " + e.getCause().getMessage();
            }
            log.error(messageShort + ": " + messageLong, (Throwable)e);
            throw new DetailedSerializationException(messageShort, messageLong);
        }
        catch (Exception e) {
            log.error("Unable to run the scenario.", (Throwable)e);
            throw new DetailedSerializationException("Unable to run the scenario.", e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BulkTestRunResult runScenariosInPackage(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(packageUUID);
        PackageItem item = this.getRulesRepository().loadPackageByUUID(packageUUID);
        return this.runScenariosInPackage(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkTestRunResult runScenariosInPackage(PackageItem packageItem) throws DetailedSerializationException, SerializationException {
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        CompositeClassLoader classloader = null;
        try {
            if (packageItem.isBinaryUpToDate() && RuleBaseCache.getInstance().contains(packageItem.getUUID())) {
                AbstractRuleBase arb = (AbstractRuleBase)RuleBaseCache.getInstance().get(packageItem.getUUID());
                classloader = arb.getConfiguration().getClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)classloader);
            } else {
                ClassLoaderBuilder classLoaderBuilder = new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"}));
                classloader = classLoaderBuilder.buildClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)classloader);
                if (packageItem.isBinaryUpToDate()) {
                    RuleBaseCache.getInstance().put(packageItem.getUUID(), this.loadRuleBase(packageItem, (ClassLoader)classloader));
                } else {
                    BuilderResult result = this.repositoryPackageOperations.buildPackage(packageItem, false);
                    if (result == null || result.getLines().size() == 0) {
                        RuleBaseCache.getInstance().put(packageItem.getUUID(), this.loadRuleBase(packageItem, (ClassLoader)classloader));
                    } else {
                        BulkTestRunResult bulkTestRunResult = new BulkTestRunResult(result, null, 0, null);
                        return bulkTestRunResult;
                    }
                }
            }
            AssetItemIterator it = packageItem.listAssetsByFormat(new String[]{"scenario"});
            ArrayList<ScenarioResultSummary> resultSummaries = new ArrayList<ScenarioResultSummary>();
            RuleBase rb = RuleBaseCache.getInstance().get(packageItem.getUUID());
            Package bin = rb.getPackages()[0];
            RuleCoverageListener coverage = new RuleCoverageListener(this.expectedRules(bin));
            while (it.hasNext()) {
                AssetItem as = it.next();
                if (as.getDisabled()) continue;
                RuleAsset asset = this.repositoryAssetOperations.loadAsset(as);
                Scenario sc = (Scenario)asset.getContent();
                this.runScenario(packageItem.getName(), sc, coverage);
                int[] totals = sc.countFailuresTotal();
                resultSummaries.add(new ScenarioResultSummary(totals[0], totals[1], asset.getName(), asset.getDescription(), asset.getUuid()));
            }
            ScenarioResultSummary[] summaries = resultSummaries.toArray(new ScenarioResultSummary[resultSummaries.size()]);
            BulkTestRunResult bulkTestRunResult = new BulkTestRunResult(null, resultSummaries.toArray(summaries), coverage.getPercentCovered(), coverage.getUnfiredRules());
            return bulkTestRunResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    private HashSet<String> expectedRules(Package bin) {
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < bin.getRules().length; ++i) {
            h.add(bin.getRules()[i].getName());
        }
        return h;
    }
}

