/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import org.drools.guvnor.server.repository.RepositoryStartupService;
import org.drools.repository.RulesRepository;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

@Scope(value=ScopeType.EVENT)
@AutoCreate
@Name(value="repository")
public class RulesRepositoryManager {
    @In
    RepositoryStartupService repositoryConfiguration;
    private RulesRepository repository;

    @Create
    public void create() {
        String DEFAULT_USER;
        String userName = DEFAULT_USER = "guest";
        if (Contexts.isApplicationContextActive()) {
            userName = Identity.instance().getCredentials().getUsername();
        }
        if (userName == null) {
            userName = DEFAULT_USER;
        }
        this.repository = new RulesRepository(this.repositoryConfiguration.newSession(userName));
    }

    @Unwrap
    public RulesRepository getRepository() {
        return this.repository;
    }

    @Destroy
    public void close() {
        this.repository.logout();
    }
}

