/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.Iterator;
import org.drools.guvnor.server.builder.AssemblerBase;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

public class PackageDRLAssembler
extends AssemblerBase {
    private StringBuilder src;

    public PackageDRLAssembler(PackageItem packageItem) {
        super(packageItem);
    }

    public String getDRL() {
        this.src = new StringBuilder();
        this.loadHeader();
        this.loadDSLFiles();
        this.loadDeclaredTypes();
        this.loadFunctions();
        this.loadRuleAssets();
        return this.src.toString();
    }

    private void loadHeader() {
        this.src.append("package ").append(this.packageItem.getName()).append("\n");
        this.src.append(DroolsHeader.getDroolsHeader((PackageItem)this.packageItem)).append("\n\n");
    }

    private void loadDeclaredTypes() {
        Iterator assetItemIterator = this.getAssetItemIterator(new String[]{"model.drl"});
        while (assetItemIterator.hasNext()) {
            this.addAsset((AssetItem)assetItemIterator.next());
        }
    }

    private void loadFunctions() {
        Iterator assetItemIterator = this.getAssetItemIterator(new String[]{"function"});
        while (assetItemIterator.hasNext()) {
            this.addAsset((AssetItem)assetItemIterator.next());
        }
    }

    private void loadRuleAssets() {
        Iterator assetItemIterator = this.getAllAssets();
        while (assetItemIterator.hasNext()) {
            this.addRuleAsset((AssetItem)assetItemIterator.next());
        }
    }

    private void addRuleAsset(AssetItem asset) {
        if (!asset.isArchived() && !asset.getDisabled()) {
            ContentHandler handler = ContentManager.getHandler((String)asset.getFormat());
            if (handler.isRuleAsset()) {
                IRuleAsset ruleAsset = (IRuleAsset)handler;
                ruleAsset.assembleDRL(this.builder, asset, this.src);
            }
            this.src.append("\n\n");
        }
    }

    private void addAsset(AssetItem assetItem) {
        if (!assetItem.isArchived() && !assetItem.getDisabled()) {
            this.src.append(assetItem.getContent()).append("\n\n");
        }
    }
}

