/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.server.builder.PackageDRLAssembler;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.jaxrs.Resource;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.jaxrs.jaxb.Package;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageHistoryIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.jboss.seam.annotations.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="PackageResource")
@Path(value="/packages")
public class PackageResource
extends Resource {
    private HttpHeaders headers;

    @Context
    public void setHttpHeaders(HttpHeaders theHeaders) {
        this.headers = theHeaders;
    }

    @GET
    @Produces(value={"application/atom+xml"})
    public Feed getPackagesAsFeed() {
        Factory factory = Abdera.getNewFactory();
        Feed f = factory.getAbdera().newFeed();
        f.setTitle("Packages");
        f.setBaseUri(this.uriInfo.getBaseUriBuilder().path("packages").build(new Object[0]).toString());
        PackageIterator iter = this.repository.listPackages();
        while (iter.hasNext()) {
            PackageItem item = iter.next();
            Entry e = factory.getAbdera().newEntry();
            e.setTitle(item.getName());
            Link l = factory.newLink();
            l.setHref(this.uriInfo.getBaseUriBuilder().path("packages/{itemName}").build(new Object[]{item.getName()}).toString());
            e.addLink(l);
            f.addEntry(e);
        }
        return f;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<Package> getPackagesAsJAXB() {
        ArrayList<Package> ret = new ArrayList<Package>();
        PackageIterator iter = this.repository.listPackages();
        while (iter.hasNext()) {
            ret.add(Translator.toPackage((PackageItem)iter.next(), (UriInfo)this.uriInfo));
        }
        return ret;
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/atom+xml"})
    public Entry createPackageFromDRLAndReturnAsEntry(InputStream is, @Context UriInfo uriInfo) {
        try {
            String packageName = RepositoryServlet.getFileManager().importClassicDRL(is, null);
            return Translator.toPackageEntryAbdera((PackageItem)this.repository.loadPackage(packageName), (UriInfo)uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json", "application/xml"})
    public Package createPackageFromDRLAndReturnAsJaxB(InputStream is) {
        try {
            String packageName = RepositoryServlet.getFileManager().importClassicDRL(is, null);
            return Translator.toPackage((PackageItem)this.repository.loadPackage(packageName), (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/atom+xml"})
    @Produces(value={"application/atom+xml"})
    public Entry createPackageFromAtom(Entry entry) {
        try {
            PackageItem packageItem = this.repository.createPackage(entry.getTitle(), entry.getSummary());
            return Translator.toPackageEntryAbdera((PackageItem)packageItem, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Package createPackageFromJAXB(Package p) {
        try {
            PackageItem packageItem = this.repository.createPackage(p.getTitle(), p.getDescription());
            return Translator.toPackage((PackageItem)packageItem, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}")
    @Produces(value={"application/atom+xml"})
    public Entry getPackageAsEntry(@PathParam(value="packageName") String packageName) {
        try {
            PackageItem packageItem = this.repository.loadPackage(packageName);
            return Translator.toPackageEntryAbdera((PackageItem)packageItem, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}")
    @Produces(value={"application/json", "application/xml"})
    public Package getPackageAsJAXB(@PathParam(value="packageName") String packageName) {
        try {
            PackageItem packageItem = this.repository.loadPackage(packageName);
            return Translator.toPackage((PackageItem)packageItem, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/source")
    @Produces(value={"text/plain"})
    public Response getPackageSource(@PathParam(value="packageName") String packageName) {
        try {
            PackageItem packageItem = this.repository.loadPackage(packageName);
            PackageDRLAssembler asm = new PackageDRLAssembler(packageItem);
            String drl = asm.getDRL();
            return Response.ok((Object)drl).header("Content-Disposition", (Object)("attachment; filename=" + packageName)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getPackageBinary(@PathParam(value="packageName") String packageName) throws SerializationException {
        try {
            byte[] result;
            PackageItem p = this.repository.loadPackage(packageName);
            String fileName = packageName + ".pkg";
            if (p.isBinaryUpToDate()) {
                result = p.getCompiledPackageBytes();
            } else {
                BuilderResult builderResult = this.packageService.buildPackage(p.getUUID(), true);
                if (builderResult != null) {
                    StringBuilder errs = new StringBuilder();
                    errs.append("Unable to build package name [").append(packageName).append("]\n");
                    for (BuilderResultLine resultLine : builderResult.getLines()) {
                        errs.append(resultLine.toString()).append("\n");
                    }
                    return Response.status((int)500).entity((Object)errs.toString()).build();
                }
                result = this.repository.loadPackage(packageName).getCompiledPackageBytes();
            }
            return Response.ok((Object)result).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/versions")
    @Produces(value={"application/atom+xml"})
    public Feed getPackageVersionsAsFeed(@PathParam(value="packageName") String packageName) throws SerializationException {
        PackageItem p = this.repository.loadPackage(packageName);
        Factory factory = Abdera.getNewFactory();
        Feed f = factory.getAbdera().newFeed();
        f.setTitle("Version history of " + p.getName());
        f.setBaseUri(this.uriInfo.getBaseUriBuilder().path("packages").build(new Object[0]).toString());
        PackageHistoryIterator it = p.getHistory();
        while (it.hasNext()) {
            try {
                PackageItem historicalPackage = it.next();
                if (historicalPackage.getVersionNumber() == 0L) continue;
                Entry e = factory.getAbdera().newEntry();
                e.setTitle(Long.toString(historicalPackage.getVersionNumber()));
                e.setUpdated(historicalPackage.getLastModified().getTime());
                Link l = factory.newLink();
                l.setHref(this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/versions/{versionNumber}").build(new Object[]{p.getName(), Long.toString(historicalPackage.getVersionNumber())}).toString());
                e.addLink(l);
                f.addEntry(e);
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        return f;
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}")
    @Produces(value={"application/atom+xml"})
    public Entry getHistoricalPackageAsEntry(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) throws SerializationException {
        return Translator.toPackageEntryAbdera((PackageItem)this.repository.loadPackage(packageName, versionNumber), (UriInfo)this.uriInfo);
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}/source")
    @Produces(value={"text/plain"})
    public Response getHistoricalPackageSource(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) {
        PackageItem item = this.repository.loadPackage(packageName, versionNumber);
        PackageDRLAssembler asm = new PackageDRLAssembler(item);
        String drl = asm.getDRL();
        return Response.ok((Object)drl).header("Content-Disposition", (Object)("attachment; filename=" + packageName)).build();
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getHistoricalPackageBinary(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) throws SerializationException {
        PackageItem p = this.repository.loadPackage(packageName, versionNumber);
        byte[] result = p.getCompiledPackageBytes();
        if (result != null) {
            String fileName = packageName + ".pkg";
            return Response.ok((Object)result).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        return Response.status((int)500).entity((Object)"This package version has no compiled binary").type("text/plain").build();
    }

    @PUT
    @Path(value="{packageName}")
    @Consumes(value={"application/atom+xml"})
    public void updatePackageFromAtom(@PathParam(value="packageName") String packageName, Entry entry) {
        try {
            ExtensibleElement archivedExtension;
            ExtensibleElement metadataExtension;
            PackageItem p = this.repository.loadPackage(packageName);
            p.checkout();
            if (entry.getSummary() != null) {
                p.updateDescription(entry.getSummary());
            }
            if (entry.getAuthor() != null) {
                // empty if block
            }
            if ((metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA)) != null && (archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED)) != null) {
                p.archiveItem(Boolean.getBoolean(archivedExtension.getSimpleExtension(Translator.VALUE)));
            }
            p.checkin("Updated from ATOM.");
            this.repository.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}")
    @Consumes(value={"application/json", "application/xml"})
    public void updatePackageFromJAXB(@PathParam(value="packageName") String packageName, Package p) {
        try {
            PackageItem item = this.repository.loadPackage(packageName);
            item.checkout();
            item.updateDescription(p.getDescription());
            item.updateTitle(p.getTitle());
            item.checkin(p.getCheckInComment());
            this.repository.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{packageName}")
    public void deletePackage(@PathParam(value="packageName") String packageName) {
        try {
            PackageItem p = this.repository.loadPackage(packageName);
            this.packageService.removePackage(p.getUUID());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets")
    @Produces(value={"application/atom+xml"})
    public Feed getAssetsAsAtom(@PathParam(value="packageName") String packageName, @QueryParam(value="format") List<String> formats) {
        try {
            Factory factory = Abdera.getNewFactory();
            Feed feed = factory.getAbdera().newFeed();
            PackageItem p = this.repository.loadPackage(packageName);
            feed.setTitle(p.getTitle() + "-asset-feed");
            Iterator iter = null;
            iter = formats.isEmpty() ? p.getAssets() : p.listAssetsByFormat(formats);
            while (iter.hasNext()) {
                feed.addEntry(Translator.toAssetEntryAbdera((AssetItem)((AssetItem)iter.next()), (UriInfo)this.uriInfo));
            }
            return feed;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Asset> getAssetsAsJAXB(@PathParam(value="packageName") String packageName, @QueryParam(value="format") List<String> formats) {
        try {
            ArrayList<Asset> ret = new ArrayList<Asset>();
            PackageItem p = this.repository.loadPackage(packageName);
            Iterator iter = null;
            iter = formats.isEmpty() ? p.getAssets() : p.listAssetsByFormat(formats);
            while (iter.hasNext()) {
                ret.add(Translator.toAsset((AssetItem)((AssetItem)iter.next()), (UriInfo)this.uriInfo));
            }
            return ret;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}")
    @Produces(value={"application/atom+xml"})
    public Entry getAssetAsAtom(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName);
            return Translator.toAssetEntryAbdera((AssetItem)asset, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}")
    @Produces(value={"application/json", "application/xml"})
    public Asset getAssetAsJaxB(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName);
            return Translator.toAsset((AssetItem)asset, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getAssetBinary(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName);
            String fileName = asset.getName() + "." + asset.getFormat();
            return Response.ok((Object)asset.getBinaryContentAttachment()).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/source")
    @Produces(value={"text/plain"})
    public String getAssetSource(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName);
            return asset.getContent();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="{packageName}/assets")
    @Consumes(value={"application/atom+xml"})
    @Produces(value={"application/atom+xml"})
    public Entry createAssetFromAtom(@PathParam(value="packageName") String packageName, Entry entry) {
        try {
            String format = null;
            String initialCategory = null;
            ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
            if (metadataExtension != null) {
                ExtensibleElement formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
                format = formatExtension != null ? formatExtension.getSimpleExtension(Translator.VALUE) : null;
                ExtensibleElement categoryExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CATEGORIES);
                initialCategory = formatExtension != null ? categoryExtension.getSimpleExtension(Translator.VALUE) : null;
            }
            AssetItem ai = this.repository.loadPackage(packageName).addAsset(entry.getTitle(), entry.getSummary(), initialCategory, format);
            this.repository.getSession().save();
            return Translator.toAssetEntryAbdera((AssetItem)ai, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="{packageName}/assets")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/atom+xml"})
    public Entry createAssetFromBinary(@PathParam(value="packageName") String packageName, InputStream is) {
        try {
            String assetName = this.getHttpHeader(this.headers, "slug");
            if (assetName == null) {
                throw new WebApplicationException(Response.status((int)500).entity((Object)"Slug header is missing").build());
            }
            String fileName = null;
            String extension = null;
            if (assetName.lastIndexOf(".") != -1) {
                fileName = assetName.substring(0, assetName.lastIndexOf("."));
                extension = assetName.substring(assetName.lastIndexOf(".") + 1);
            } else {
                fileName = assetName;
            }
            AssetItem ai = this.repository.loadPackage(packageName).addAsset(fileName, "");
            ai.checkout();
            ai.updateBinaryContentAttachmentFileName(fileName);
            if (extension != null) {
                ai.updateFormat(extension);
            }
            ai.updateBinaryContentAttachment(is);
            ai.getPackage().updateBinaryUpToDate(false);
            ai.checkin("update binary");
            this.repository.save();
            return Translator.toAssetEntryAbdera((AssetItem)ai, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}")
    @Consumes(value={"application/atom+xml"})
    public void updateAssetFromAtom(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, Entry assetEntry) {
        try {
            String format = null;
            String[] categories = null;
            String state = null;
            ExtensibleElement metadataExtension = (ExtensibleElement)assetEntry.getExtension(Translator.METADATA);
            if (metadataExtension != null) {
                ExtensibleElement stateExtension;
                ExtensibleElement formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
                format = formatExtension != null ? formatExtension.getSimpleExtension(Translator.VALUE) : null;
                ExtensibleElement categoryExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CATEGORIES);
                if (categoryExtension != null) {
                    List categoryValues = categoryExtension.getExtensions(Translator.VALUE);
                    categories = new String[categoryValues.size()];
                    for (int i = 0; i < categoryValues.size(); ++i) {
                        String catgoryValue;
                        categories[i] = catgoryValue = ((Element)categoryValues.get(i)).getText();
                    }
                }
                state = (stateExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.STATE)) != null ? stateExtension.getSimpleExtension(Translator.VALUE) : null;
            }
            AssetItem ai = this.repository.loadPackage(packageName).loadAsset(assetName);
            ai.checkout();
            ai.updateTitle(assetEntry.getTitle());
            ai.updateDescription(assetEntry.getSummary());
            if (format != null) {
                ai.updateFormat(format);
            }
            if (assetEntry.getContent() != null && !"".equals(assetEntry.getContent())) {
                ai.updateContent(assetEntry.getContent());
            }
            if (categories != null) {
                ai.updateCategoryList(categories);
            }
            if (state != null) {
                ai.updateState(state);
            }
            ai.checkin("Check-in (summary): " + assetEntry.getSummary());
            this.repository.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}")
    @Consumes(value={"application/json", "application/xml"})
    public void updateAssetFromJAXB(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, Asset asset) {
        try {
            AssetItem ai = this.repository.loadPackage(packageName).loadAsset(assetName);
            ai.checkout();
            ai.updateTitle(asset.getMetadata().getTitle());
            ai.updateDescription(asset.getDescription());
            ai.checkin(asset.getCheckInComment());
            this.repository.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}/source")
    @Consumes(value={"application/json", "application/xml"})
    public void updateAssetSource(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, String content) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName);
            asset.checkout();
            asset.updateContent(content);
            this.repository.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}/binary")
    @Consumes(value={"application/octet-stream"})
    public void updateAssetBinary(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, InputStream is) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName);
            asset.checkout();
            asset.updateBinaryContentAttachment(is);
            asset.checkin("Update binary");
            this.repository.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{packageName}/assets/{assetName}/")
    public void deleteAsset(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem ai = this.repository.loadPackage(packageName).loadAsset(assetName);
            this.assetService.removeAsset(ai.getUUID());
            this.repository.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions")
    @Produces(value={"application/atom+xml"})
    public Feed getAssetVersionsAsFeed(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName);
            Factory factory = Abdera.getNewFactory();
            Feed f = factory.getAbdera().newFeed();
            f.setTitle("Version history of " + asset.getName());
            URI base = asset.isHistoricalVersion() ? this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions/{versionNumber}").build(new Object[]{asset.getPackageName(), asset.getName(), Long.toString(asset.getVersionNumber())}) : this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions").build(new Object[]{asset.getPackageName(), asset.getName()});
            f.setBaseUri(base.toString());
            AssetHistoryIterator it = asset.getHistory();
            while (it.hasNext()) {
                AssetItem historicalAsset = it.next();
                if (historicalAsset.getVersionNumber() == 0L) continue;
                Entry e = factory.getAbdera().newEntry();
                e.setTitle(Long.toString(historicalAsset.getVersionNumber()));
                e.setUpdated(historicalAsset.getLastModified().getTime());
                Link l = factory.newLink();
                l.setHref(this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions/{versionNumber}").build(new Object[]{asset.getPackageName(), asset.getName(), Long.toString(historicalAsset.getVersionNumber())}).toString());
                e.addLink(l);
                f.addEntry(e);
            }
            return f;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions/{versionNumber}")
    @Produces(value={"application/atom+xml"})
    public Entry getHistoricalAssetAsEntry(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, @PathParam(value="versionNumber") long versionNumber) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName, versionNumber);
            return Translator.toAssetEntryAbdera((AssetItem)asset, (UriInfo)this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions/{versionNumber}/source")
    @Produces(value={"text/plain"})
    public String getHistoricalAssetSource(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, @PathParam(value="versionNumber") long versionNumber) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName, versionNumber);
            return asset.getContent();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions/{versionNumber}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getHistoricalAssetBinary(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, @PathParam(value="versionNumber") long versionNumber) {
        try {
            AssetItem asset = this.repository.loadPackage(packageName).loadAsset(assetName, versionNumber);
            String fileName = asset.getName() + "." + asset.getFormat();
            return Response.ok((Object)asset.getBinaryContentAttachment()).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private String getHttpHeader(HttpHeaders headers, String headerName) {
        MultivaluedMap heads = headers.getRequestHeaders();
        for (String key : heads.keySet()) {
            List h;
            if (!headerName.equalsIgnoreCase(key) || (h = (List)heads.get((Object)key)) == null || h.size() <= 0) continue;
            return (String)h.get(0);
        }
        return null;
    }
}

