/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.categorynav;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.CategoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryExplorerWidget
extends Composite
implements SelectionHandler<TreeItem>,
OpenHandler<TreeItem> {
    private static Images images = (Images)GWT.create(Images.class);
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private Tree navTreeWidget = new Tree();
    private VerticalPanel panel = new VerticalPanel();
    private CategoryServiceAsync categoryService = RepositoryServiceFactory.getCategoryService();
    private CategorySelectHandler categorySelectHandler;
    private String selectedPath;
    private Panel emptyCategories;

    public void setTreeSize(String width) {
        this.navTreeWidget.setWidth(width);
    }

    public CategoryExplorerWidget(CategorySelectHandler handler) {
        this.panel.add((Widget)this.navTreeWidget);
        this.categorySelectHandler = handler;
        this.loadInitialTree();
        this.initWidget((Widget)this.panel);
        this.navTreeWidget.addSelectionHandler((SelectionHandler)this);
        this.navTreeWidget.addOpenHandler((OpenHandler)this);
        this.setStyleName("category-explorer-Tree");
    }

    public void refresh() {
        this.navTreeWidget.removeItems();
        this.selectedPath = null;
        this.loadInitialTree();
    }

    public void showEmptyTree() {
        if (this.emptyCategories == null) {
            AbsolutePanel p = new AbsolutePanel();
            p.add((Widget)new HTML(constants.NoCategoriesCreatedYetTip()));
            Button b = new Button(constants.Refresh());
            b.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            p.add((Widget)b);
            p.setStyleName("small-Text");
            this.emptyCategories = p;
            this.panel.add((Widget)this.emptyCategories);
        }
        this.navTreeWidget.setVisible(false);
        this.emptyCategories.setVisible(true);
    }

    private void loadInitialTree() {
        this.navTreeWidget.addItem(constants.PleaseWait());
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String h(String cat) {
        return cat.replace("<", "&lt;").replace(">", "&gt;");
    }

    private void hideEmptyTree() {
        if (this.emptyCategories != null) {
            this.emptyCategories.setVisible(false);
        }
        this.navTreeWidget.setVisible(true);
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        this.selectedPath = this.getPath((TreeItem)event.getSelectedItem());
        this.categorySelectHandler.selected(this.selectedPath);
    }

    public void onOpen(OpenEvent<TreeItem> event) {
        TreeItem item = (TreeItem)event.getTarget();
        if (this.hasBeenLoaded(item)) {
            return;
        }
        TreeItem root = item;
        this.selectedPath = this.getPath(item);
        this.categoryService.loadChildCategories(this.selectedPath, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean hasBeenLoaded(TreeItem item) {
        return item.getChildCount() != 1 || !(item.getChild(0) instanceof PendingItem);
    }

    private String getPath(TreeItem item) {
        String categoryPath = (String)item.getUserObject();
        if (categoryPath == null) {
            return null;
        }
        TreeItem parent = item.getParentItem();
        while (parent.getUserObject() != null) {
            categoryPath = (String)parent.getUserObject() + "/" + categoryPath;
            parent = parent.getParentItem();
        }
        return categoryPath;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean isSelected() {
        return this.selectedPath != null;
    }

    static /* synthetic */ String access$002(CategoryExplorerWidget x0, String x1) {
        x0.selectedPath = x1;
        return x0.selectedPath;
    }

    static /* synthetic */ Tree access$100(CategoryExplorerWidget x0) {
        return x0.navTreeWidget;
    }

    static /* synthetic */ Images access$200() {
        return images;
    }

    static /* synthetic */ void access$300(CategoryExplorerWidget x0) {
        x0.hideEmptyTree();
    }

    static /* synthetic */ String access$400(CategoryExplorerWidget x0, String x1) {
        return x0.h(x1);
    }

    static /* synthetic */ CategoryServiceAsync access$500(CategoryExplorerWidget x0) {
        return x0.categoryService;
    }

    static /* synthetic */ Constants access$600() {
        return constants;
    }
}

