/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui.factPattern;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.CEPOperatorsDropdown;
import org.drools.guvnor.client.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

public class Connectives {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private RuleModeller modeller;
    private FactPattern pattern;
    private Boolean isReadOnly;

    public Connectives(RuleModeller modeller, FactPattern pattern, Boolean isReadOnly) {
        this.pattern = pattern;
        this.modeller = modeller;
        this.isReadOnly = isReadOnly;
    }

    public FactPattern getPattern() {
        return this.pattern;
    }

    public SuggestionCompletionEngine getCompletions() {
        return this.modeller.getSuggestionCompletions();
    }

    public Widget connectives(SingleFieldConstraint c, String factClass) {
        HorizontalPanel hp = new HorizontalPanel();
        if (c.connectives != null && c.connectives.length > 0) {
            hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
            for (int i = 0; i < c.connectives.length; ++i) {
                ConnectiveConstraint con = c.connectives[i];
                hp.add(this.connectiveOperatorDropDown(con));
                hp.add(this.connectiveValueEditor((BaseSingleFieldConstraint)con));
                if (this.isReadOnly.booleanValue()) continue;
                ImageButton clear = new ImageButton(images.deleteItemSmall());
                clear.setTitle(this.constants.RemoveThisRestriction());
                clear.addClickHandler(this.createClickHandlerForClearImageButton(c, i));
                hp.add((Widget)clear);
            }
        }
        return hp;
    }

    private Widget connectiveValueEditor(BaseSingleFieldConstraint con) {
        return new ConstraintValueEditor(con, this.pattern.constraintList, this.modeller, this.isReadOnly.booleanValue());
    }

    private Widget connectiveOperatorDropDown(ConnectiveConstraint cc) {
        if (!this.isReadOnly.booleanValue()) {
            String factType = cc.getFactType();
            String fieldName = cc.getFieldName();
            String[] operators = this.getCompletions().getConnectiveOperatorCompletions(factType, fieldName);
            CEPOperatorsDropdown w = new CEPOperatorsDropdown(operators, (HasParameterizedOperator)cc);
            w.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            return w;
        }
        SmallLabel sl = new SmallLabel("<b>" + (cc.getOperator() == null ? this.constants.pleaseChoose() : HumanReadable.getOperatorDisplayName((String)cc.getOperator())) + "</b>");
        return sl;
    }

    private ClickHandler createClickHandlerForClearImageButton(SingleFieldConstraint sfc, int index) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Constants access$000(Connectives x0) {
        return x0.constants;
    }

    static /* synthetic */ RuleModeller access$100(Connectives x0) {
        return x0.modeller;
    }
}

