/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.PackageHeaderHelper;
import org.drools.guvnor.client.packages.PackageHeaderWidget;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageHeaderWidget
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private PackageConfigData conf;
    private SimplePanel layout;
    private ListBox importList;
    private ListBox globalList;
    private boolean isHistoricalReadOnly = false;

    public PackageHeaderWidget(PackageConfigData conf, boolean isHistoricalReadOnly) {
        this.conf = conf;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        this.layout = new SimplePanel();
        this.render();
        this.initWidget((Widget)this.layout);
    }

    private void render() {
        Types t = PackageHeaderHelper.parseHeader((String)this.conf.getHeader());
        if (t == null) {
            this.textEditorVersion();
        } else {
            this.basicEditorVersion(t);
        }
    }

    private void basicEditorVersion(Types t) {
        ImageButton newItemButton;
        ImageButton trashButton;
        ImageButton newItemButton2;
        this.layout.clear();
        HorizontalPanel main = new HorizontalPanel();
        VerticalPanel imports = new VerticalPanel();
        imports.add((Widget)new Label(this.constants.ImportedTypes()));
        this.importList = new ListBox(true);
        this.doImports(t);
        HorizontalPanel importCols = new HorizontalPanel();
        importCols.add((Widget)this.importList);
        VerticalPanel importActions = new VerticalPanel();
        if (this.isHistoricalReadOnly) {
            newItemButton2 = new ImageButton(images.newItem(), images.newItemDisabled());
            newItemButton2.setEnabled(false);
            importActions.add((Widget)newItemButton2);
            trashButton = new ImageButton(images.trash(), images.trashDisabled());
            trashButton.setEnabled(false);
            importActions.add((Widget)trashButton);
        } else {
            newItemButton2 = new /* Unavailable Anonymous Inner Class!! */;
            importActions.add((Widget)newItemButton2);
            trashButton = new /* Unavailable Anonymous Inner Class!! */;
            importActions.add((Widget)trashButton);
        }
        importCols.add((Widget)importActions);
        imports.add((Widget)importCols);
        VerticalPanel globals = new VerticalPanel();
        globals.add((Widget)new Label(this.constants.Globals()));
        this.globalList = new ListBox(true);
        this.doGlobals(t);
        HorizontalPanel globalCols = new HorizontalPanel();
        globalCols.add((Widget)this.globalList);
        VerticalPanel globalActions = new VerticalPanel();
        if (this.isHistoricalReadOnly) {
            newItemButton = new ImageButton(images.newItem(), images.newItemDisabled());
            newItemButton.setEnabled(false);
            globalActions.add((Widget)newItemButton);
            ImageButton trashButton2 = new ImageButton(images.trash(), images.trashDisabled());
            trashButton2.setEnabled(false);
            globalActions.add((Widget)trashButton2);
        } else {
            newItemButton = new /* Unavailable Anonymous Inner Class!! */;
            globalActions.add((Widget)newItemButton);
            4 trashButton3 = new /* Unavailable Anonymous Inner Class!! */;
            globalActions.add((Widget)trashButton3);
        }
        globalCols.add((Widget)globalActions);
        globals.add((Widget)globalCols);
        main.add((Widget)imports);
        main.add((Widget)new HTML("&nbsp;"));
        main.add((Widget)globals);
        5 advanced = new /* Unavailable Anonymous Inner Class!! */;
        main.add((Widget)advanced);
        this.layout.add((Widget)main);
    }

    private void textEditorVersion() {
        this.layout.clear();
        VerticalPanel main = new VerticalPanel();
        TextArea area = new TextArea();
        if (this.isHistoricalReadOnly) {
            area.setEnabled(false);
        }
        area.setWidth("100%");
        area.setVisibleLines(8);
        area.setCharacterWidth(100);
        area.setText(this.conf.getHeader());
        area.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        main.add((Widget)area);
        Button basicMode = this.createBasicModeButton(area);
        main.add((Widget)basicMode);
        this.layout.add((Widget)main);
    }

    private Button createBasicModeButton(TextArea area) {
        7 basicMode = new /* Unavailable Anonymous Inner Class!! */;
        return basicMode;
    }

    private ClickHandler createClickHanderForBasicModeButton(TextArea area) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void handleCasesForBasicModeButton() {
        Types types = PackageHeaderHelper.parseHeader((String)this.conf.getHeader());
        if (types == null) {
            Window.alert((String)this.constants.CanNotSwitchToBasicView());
        } else if (types.hasDeclaredTypes) {
            Window.alert((String)this.constants.CanNotSwitchToBasicViewDeclaredTypes());
        } else if (types.hasFunctions) {
            Window.alert((String)this.constants.CanNotSwitchToBasicViewFunctions());
        } else if (types.hasRules) {
            Window.alert((String)this.constants.CanNotSwitchToBasicViewRules());
        } else if (Window.confirm((String)this.constants.SwitchToGuidedModeForPackageEditing())) {
            this.basicEditorVersion(types);
        }
    }

    private void showTypeQuestion(Widget w, Types t, boolean global, String headerMessage) {
        FormStylePopup pop = new FormStylePopup(images.homeIcon(), this.constants.ChooseAFactType());
        pop.addRow((Widget)new HTML("<small><i>" + headerMessage + " </i></small>"));
        ListBox factList = new ListBox();
        factList.addItem(this.constants.loadingList());
        RepositoryServiceFactory.getPackageService().listTypesInPackage(this.conf.getUuid(), (AsyncCallback)this.createGenericCallbackForListTypesInPackage(global, factList));
        InfoPopup info = new InfoPopup(this.constants.TypesInThePackage(), this.constants.IfNoTypesTip());
        pop.addAttribute(this.constants.ChooseClassType(), (Widget)this.createHorizontalPanel(new Widget[]{factList, info}));
        TextBox globalName = new TextBox();
        if (global) {
            pop.addAttribute(this.constants.GlobalName(), (Widget)globalName);
        }
        TextBox className = new TextBox();
        InfoPopup infoClass = new InfoPopup(this.constants.EnteringATypeClassName(), this.constants.EnterTypeNameTip());
        pop.addAttribute(this.constants.advancedClassName(), (Widget)this.createHorizontalPanel(new Widget[]{className, infoClass}));
        9 ok = new /* Unavailable Anonymous Inner Class!! */;
        10 cancel = new /* Unavailable Anonymous Inner Class!! */;
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.add((Widget)ok);
        buttonPanel.add((Widget)cancel);
        pop.addAttribute("", (Widget)buttonPanel);
        pop.show();
    }

    private HorizontalPanel createHorizontalPanel(Widget ... wigets) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        for (Widget widget : wigets) {
            horizontalPanel.add(widget);
        }
        return horizontalPanel;
    }

    private GenericCallback<String[]> createGenericCallbackForListTypesInPackage(boolean global, ListBox factList) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void updateHeader(Types t) {
        this.conf.setHeader(PackageHeaderHelper.renderTypes((Types)t));
    }

    private void doGlobals(Types t) {
        this.globalList.clear();
        for (Global g : t.globals) {
            this.globalList.addItem(g.type + " [" + g.name + "]");
        }
    }

    private void doImports(Types t) {
        this.importList.clear();
        for (Import i : t.imports) {
            this.importList.addItem(i.type);
        }
    }

    static /* synthetic */ Constants access$000(PackageHeaderWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$100(PackageHeaderWidget x0, Widget x1, Types x2, boolean x3, String x4) {
        x0.showTypeQuestion(x1, x2, x3, x4);
    }

    static /* synthetic */ ListBox access$200(PackageHeaderWidget x0) {
        return x0.importList;
    }

    static /* synthetic */ void access$300(PackageHeaderWidget x0, Types x1) {
        x0.updateHeader(x1);
    }

    static /* synthetic */ ListBox access$400(PackageHeaderWidget x0) {
        return x0.globalList;
    }

    static /* synthetic */ void access$500(PackageHeaderWidget x0) {
        x0.textEditorVersion();
    }

    static /* synthetic */ PackageConfigData access$600(PackageHeaderWidget x0) {
        return x0.conf;
    }

    static /* synthetic */ ClickHandler access$700(PackageHeaderWidget x0, TextArea x1) {
        return x0.createClickHanderForBasicModeButton(x1);
    }

    static /* synthetic */ void access$800(PackageHeaderWidget x0) {
        x0.handleCasesForBasicModeButton();
    }

    static /* synthetic */ void access$900(PackageHeaderWidget x0, Types x1) {
        x0.doImports(x1);
    }

    static /* synthetic */ void access$1000(PackageHeaderWidget x0, Types x1) {
        x0.doGlobals(x1);
    }
}

