/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rpc;

import java.util.List;
import org.drools.guvnor.client.rpc.AbstractPageRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsPageRow
extends AbstractPageRow {
    private String userName;
    private List<String> userPermissions;

    public String getUserName() {
        return this.userName;
    }

    public List<String> getUserPermissions() {
        return this.userPermissions;
    }

    public boolean isAdministrator() {
        return this.isAdministrator(this.userPermissions);
    }

    public boolean hasCategoryPermissions() {
        return this.hasCategoryPermissions(this.userPermissions);
    }

    public boolean hasPackagePermissions() {
        return this.hasPackagePermissions(this.userPermissions);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserPermissions(List<String> userPermissions) {
        this.userPermissions = userPermissions;
    }

    private boolean hasCategoryPermissions(List<String> permTypes) {
        for (String s : permTypes) {
            if (!s.startsWith("analyst")) continue;
            return true;
        }
        return false;
    }

    private boolean hasPackagePermissions(List<String> permTypes) {
        for (String s : permTypes) {
            if (!s.startsWith("package")) continue;
            return true;
        }
        return false;
    }

    private boolean isAdministrator(List<String> permTypes) {
        return permTypes.contains("admin");
    }
}

