/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.AbstractPageRow;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleTable<T extends AbstractPageRow>
extends Composite
implements HasData<T> {
    protected static final Constants constants = (Constants)GWT.create(Constants.class);
    @UiField(provided=true)
    protected ToggleButton columnPickerButton;
    @UiField(provided=true)
    protected CellTable<T> cellTable;

    public AbstractSimpleTable() {
        this.doCellTable();
        this.initWidget(this.makeWidget());
    }

    public void refresh() {
        this.cellTable.setVisibleRangeAndClearData(this.cellTable.getVisibleRange(), true);
    }

    protected abstract void addAncillaryColumns(ColumnPicker<T> var1, SortableHeaderGroup<T> var2);

    protected void doCellTable() {
        this.cellTable = new CellTable();
        ColumnPicker columnPicker = new ColumnPicker(this.cellTable);
        SortableHeaderGroup sortableHeaderGroup = new SortableHeaderGroup(this.cellTable);
        this.addAncillaryColumns(columnPicker, sortableHeaderGroup);
        this.cellTable.setWidth("100%");
        this.columnPickerButton = columnPicker.createToggleButton();
    }

    protected abstract Widget makeWidget();

    public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<T> handler) {
        return this.cellTable.addCellPreviewHandler(handler);
    }

    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.cellTable.addRangeChangeHandler(handler);
    }

    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.cellTable.addRowCountChangeHandler(handler);
    }

    public int getRowCount() {
        return this.cellTable.getRowCount();
    }

    public Range getVisibleRange() {
        return this.cellTable.getVisibleRange();
    }

    public boolean isRowCountExact() {
        return this.cellTable.isRowCountExact();
    }

    public void setRowCount(int count) {
        this.cellTable.setRowCount(count);
    }

    public void setRowCount(int count, boolean isExact) {
        this.cellTable.setRowCount(count, isExact);
    }

    public void setVisibleRange(int start, int length) {
        this.cellTable.setVisibleRange(start, length);
    }

    public void setVisibleRange(Range range) {
        this.cellTable.setVisibleRange(range);
    }

    public SelectionModel<? super T> getSelectionModel() {
        return this.cellTable.getSelectionModel();
    }

    public T getVisibleItem(int indexOnPage) {
        return (T)((AbstractPageRow)this.cellTable.getVisibleItem(indexOnPage));
    }

    public int getVisibleItemCount() {
        return this.cellTable.getVisibleItemCount();
    }

    public Iterable<T> getVisibleItems() {
        return this.cellTable.getVisibleItems();
    }

    public void setRowData(int start, List<? extends T> values) {
        this.cellTable.setRowData(start, values);
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.cellTable.setSelectionModel(selectionModel);
    }

    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.cellTable.setVisibleRangeAndClearData(range, forceRangeChangeEvent);
    }

    public void setRowData(List<? extends T> values) {
        this.setRowCount(values.size());
        this.setVisibleRange(0, values.size());
        this.setRowData(0, values);
    }
}

