/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.VersionedAssetItemIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AssemblerBase {
    protected final PackageItem packageItem;
    protected BRMSPackageBuilder builder;
    protected final AssemblyErrorLogger errorLogger = new AssemblyErrorLogger();

    protected AssemblerBase(PackageItem packageItem) {
        this.packageItem = packageItem;
        this.createBuilder();
    }

    public void createBuilder() {
        this.builder = new BRMSPackageBuilder(this.packageItem);
    }

    public boolean hasErrors() {
        return this.errorLogger.hasErrors();
    }

    public List<ContentAssemblyError> getErrors() {
        return this.errorLogger.getErrors();
    }

    protected Iterator<AssetItem> getAllAssets() {
        Iterator iterator = this.packageItem.getAssets();
        ((VersionedAssetItemIterator)iterator).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        return iterator;
    }

    protected void loadDSLFiles() {
        this.builder.setDSLFiles(DSLLoader.loadDSLMappingFiles((Iterator)this.getAssetItemIterator(new String[]{"dsl"}), (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected Iterator<AssetItem> getAssetItemIterator(String ... formats) {
        return this.packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(formats);
    }
}

