/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.RulesRepositoryException;
import org.drools.rule.MapBackedClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderBuilder {
    private final List<JarInputStream> jarInputStreams;

    public ClassLoaderBuilder(AssetItemIterator assetItemIterator) {
        this.jarInputStreams = this.getJars(assetItemIterator);
    }

    public ClassLoaderBuilder(List<JarInputStream> jarInputStreams) {
        this.jarInputStreams = jarInputStreams;
    }

    private List<JarInputStream> getJars(AssetItemIterator assetItemIterator) {
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        while (assetItemIterator.hasNext()) {
            AssetItem item = assetItemIterator.next();
            if (item.getBinaryContentAttachment() == null) continue;
            try {
                jarInputStreams.add(new JarInputStream(item.getBinaryContentAttachment(), false));
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
        return jarInputStreams;
    }

    public List<JarInputStream> getJarInputStreams() {
        return this.jarInputStreams;
    }

    public MapBackedClassLoader buildClassLoader() {
        MapBackedClassLoader mapBackedClassLoader = this.getMapBackedClassLoader();
        try {
            for (JarInputStream jis : this.jarInputStreams) {
                JarEntry entry = null;
                byte[] buf = new byte[1024];
                int len = 0;
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (entry.isDirectory() || entry.getName().endsWith(".java")) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = jis.read(buf)) >= 0) {
                        out.write(buf, 0, len);
                    }
                    mapBackedClassLoader.addResource(entry.getName(), out.toByteArray());
                }
            }
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        return mapBackedClassLoader;
    }

    private MapBackedClassLoader getMapBackedClassLoader() {
        return (MapBackedClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private ClassLoader getParentClassLoader() {
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = BRMSPackageBuilder.class.getClassLoader();
        }
        return parentClassLoader;
    }

    public boolean hasJars() {
        return this.jarInputStreams != null && !this.jarInputStreams.isEmpty();
    }

    static /* synthetic */ ClassLoader access$000(ClassLoaderBuilder x0) {
        return x0.getParentClassLoader();
    }
}

