/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.WorkflowProcess;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.RuleFlowContentModelBuilder;
import org.drools.guvnor.server.builder.RuleFlowProcessBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.contenthandler.ICanRenderSource;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class BPMN2ProcessHandler
extends ContentHandler
implements ICompilable,
ICanRenderSource,
ICanHasAttachment {
    private static final LoggingHelper log = LoggingHelper.getLogger(BPMN2ProcessHandler.class);

    public void retrieveAssetContent(RuleAsset asset, AssetItem item) throws SerializationException {
        RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(item.getContent().getBytes()));
        if (process != null) {
            RuleFlowContentModel content = RuleFlowContentModelBuilder.createModel((RuleFlowProcess)process);
            content.setXml(item.getContent());
            asset.setContent((PortableObject)content);
        } else {
            RuleFlowContentModel content = new RuleFlowContentModel();
            content.setXml(item.getContent());
            asset.setContent((PortableObject)content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuleFlowProcess readProcess(InputStream is) {
        RuleFlowProcess process;
        block19: {
            List processes = null;
            process = null;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(is);
                PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
                configuration.initSemanticModules();
                configuration.addSemanticModule((SemanticModule)new BPMNSemanticModule());
                configuration.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
                XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules(), BPMN2ProcessHandler.getClassLoader());
                processes = xmlReader.read((Reader)reader);
                if (processes.size() == 0) {
                    String message = "BPMN2Process not found.";
                    log.error("BPMN2Process not found.");
                    throw new RuntimeException("BPMN2Process not found.");
                }
                if (processes.size() > 1) {
                    String message = "An asset can only contain one BPMN2Process. Multiple were detected.";
                    log.error("An asset can only contain one BPMN2Process. Multiple were detected.");
                    throw new RuntimeException("An asset can only contain one BPMN2Process. Multiple were detected.");
                }
                if (processes.get(0) instanceof RuleFlowProcess) {
                    process = (RuleFlowProcess)processes.get(0);
                    break block19;
                }
                String message = "The asset does not contain a BPMN2Process. Unable to process.";
                log.error("The asset does not contain a BPMN2Process. Unable to process.");
                throw new RuntimeException("The asset does not contain a BPMN2Process. Unable to process.");
            }
            catch (SAXException se) {
                log.error(se.getMessage());
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        log.error(ioe.getMessage());
                    }
                }
            }
        }
        return process;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleFlowContentModel content = (RuleFlowContentModel)asset.getContent();
        if (content != null) {
            if (content.getXml() != null && !asset.getFormat().equals("bpmn2") && !asset.getFormat().equals("bpmn")) {
                RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(content.getXml().getBytes()));
                if (process != null) {
                    RuleFlowProcessBuilder.updateProcess((RuleFlowProcess)process, (Collection)content.getNodes());
                    XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
                    String out = dumper.dump((WorkflowProcess)process);
                    repoAsset.updateContent(out);
                } else {
                    repoAsset.updateContent(content.getXml());
                }
            }
            if (content.getJson() != null) {
                try {
                    String designerURL = System.getProperty("designer.url") + "/" + System.getProperty("designer.context");
                    designerURL = designerURL + "/uuidRepository?profile=" + System.getProperty("designer.profile") + "&action=toXML&pp=";
                    String xml = BPMN2ProcessHandler.serialize((String)(designerURL + URLEncoder.encode(content.getPreprocessingdata(), "UTF-8")), (String)content.getJson());
                    content.setXml(xml);
                    repoAsset.updateContent(content.getXml());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(String serializeUrl, String modelJson) throws IOException {
        OutputStream out = null;
        InputStream content = null;
        ByteArrayOutputStream bos = null;
        try {
            modelJson = "&data=" + URLEncoder.encode(modelJson, "UTF-8");
            byte[] bytes = modelJson.getBytes("UTF-8");
            HttpURLConnection connection = (HttpURLConnection)new URL(serializeUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            connection.setDoOutput(true);
            out = connection.getOutputStream();
            out.write(bytes);
            out.close();
            content = connection.getInputStream();
            bos = new ByteArrayOutputStream();
            int b = 0;
            while ((b = content.read()) > -1) {
                bos.write(b);
            }
            bytes = bos.toByteArray();
            content.close();
            bos.close();
            String string = new String(bytes, "UTF-8");
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (content != null) {
                    content.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void onAttachmentAdded(AssetItem item) throws IOException {
        String originalPackageName;
        String packageName;
        RuleFlowProcess process;
        String content = item.getContent();
        if (content != null && !content.equals("") && (process = this.readProcess((InputStream)new ByteArrayInputStream(content.getBytes()))) != null && !(packageName = item.getPackageName()).equals(originalPackageName = process.getPackageName())) {
            process.setPackageName(packageName);
            XmlBPMNProcessDumper dumper = XmlBPMNProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)process);
            item.updateContent(out);
            item.checkin("Changed BPMN2 process package from " + originalPackageName + " to " + packageName);
        }
    }

    public void onAttachmentRemoved(AssetItem item) throws IOException {
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        InputStream ins = asset.getBinaryContentAttachment();
        if (ins != null) {
            builder.addProcessFromXml((Reader)new InputStreamReader(asset.getBinaryContentAttachment()));
        }
    }

    public void assembleSource(PortableObject assetContent, StringBuilder stringBuilder) {
        RuleFlowContentModel content = (RuleFlowContentModel)assetContent;
        if (content.getXml() != null && content.getXml().length() > 0) {
            stringBuilder.append(content.getXml());
        } else if (content.getJson() != null && content.getJson().length() > 0) {
            try {
                String designerURL = System.getProperty("designer.url") + "/" + System.getProperty("designer.context");
                designerURL = designerURL + "/uuidRepository?profile=" + System.getProperty("designer.profile") + "&action=toXML&pp=";
                String xml = BPMN2ProcessHandler.serialize((String)(designerURL + URLEncoder.encode(content.getPreprocessingdata(), "UTF-8")), (String)content.getJson());
                stringBuilder.append(StringEscapeUtils.escapeXml((String)xml));
            }
            catch (IOException e) {
                log.error("Exception converting to xml: " + e.getMessage());
            }
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BPMN2ProcessHandler.class.getClassLoader();
        }
        return cl;
    }
}

