/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CapabilityCalculator {
    public List<Capability> calcCapabilities(List<RoleBasedPermission> permissions) {
        if (permissions.size() == 0) {
            return CapabilityCalculator.grantAllCapabilities();
        }
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (RoleBasedPermission roleBasedPermission : permissions) {
            String role = roleBasedPermission.getRole();
            if (role.equals(RoleType.ADMIN.getName())) {
                return CapabilityCalculator.grantAllCapabilities();
            }
            if (role.equals(RoleType.PACKAGE_ADMIN.getName())) {
                capabilities.add(Capability.SHOW_KNOWLEDGE_BASES_VIEW);
                capabilities.add(Capability.SHOW_CREATE_NEW_ASSET);
                capabilities.add(Capability.SHOW_CREATE_NEW_PACKAGE);
                capabilities.add(Capability.SHOW_DEPLOYMENT);
                capabilities.add(Capability.SHOW_DEPLOYMENT_NEW);
                capabilities.add(Capability.SHOW_QA);
                continue;
            }
            if (role.equals(RoleType.PACKAGE_DEVELOPER.getName())) {
                capabilities.add(Capability.SHOW_KNOWLEDGE_BASES_VIEW);
                capabilities.add(Capability.SHOW_CREATE_NEW_ASSET);
                capabilities.add(Capability.SHOW_QA);
                continue;
            }
            if (!role.equals(RoleType.PACKAGE_READONLY.getName())) continue;
            capabilities.add(Capability.SHOW_KNOWLEDGE_BASES_VIEW);
        }
        return capabilities;
    }

    public static List<Capability> grantAllCapabilities() {
        return Arrays.asList(Capability.values());
    }
}

