/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.util.List;
import javax.security.auth.login.LoginException;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.rpc.SecurityService;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.server.security.CapabilityCalculator;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.guvnor.server.security.RoleType;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityServiceImpl
implements SecurityService {
    public static final String GUEST_LOGIN = "guest";
    private static final Logger log = LoggerFactory.getLogger(SecurityServiceImpl.class);
    private static final String[] serializationProperties = new String[]{"drools.serialization.private.keyStoreURL", "drools.serialization.private.keyStorePwd", "drools.serialization.private.keyAlias", "drools.serialization.private.keyPwd", "drools.serialization.public.keyStoreURL", "drools.serialization.public.keyStorePwd"};

    public boolean login(String userName, String password) {
        if (userName == null || userName.trim().equals("")) {
            userName = "admin";
        }
        log.info("Logging in user [" + userName + "]");
        if (Contexts.isApplicationContextActive()) {
            char[] bannedChars;
            for (char bannedChar : bannedChars = new char[]{'\'', '*', '[', ']'}) {
                if (userName.indexOf(bannedChar) < 0) continue;
                log.error("Not a valid name character " + bannedChar);
                return false;
            }
            Identity.instance().getCredentials().setUsername(userName);
            Identity.instance().getCredentials().setPassword(password);
            try {
                Identity.instance().authenticate();
            }
            catch (LoginException e) {
                log.error("Unable to login.", (Throwable)e);
                return false;
            }
            return Identity.instance().isLoggedIn();
        }
        return true;
    }

    public UserSecurityContext getCurrentUser() {
        if (Contexts.isApplicationContextActive()) {
            if (!Identity.instance().isLoggedIn()) {
                return new UserSecurityContext(this.checkAutoLogin());
            }
            return new UserSecurityContext(Identity.instance().getCredentials().getUsername());
        }
        return new UserSecurityContext("SINGLE USER MODE (DEBUG) USE ONLY");
    }

    private String checkAutoLogin() {
        Identity id = Identity.instance();
        id.getCredentials().setUsername(GUEST_LOGIN);
        try {
            id.authenticate();
        }
        catch (LoginException e) {
            return null;
        }
        if (id.isLoggedIn()) {
            return id.getCredentials().getUsername();
        }
        return null;
    }

    public List<Capability> getUserCapabilities() {
        if (Contexts.isApplicationContextActive()) {
            if (Identity.instance().hasRole(RoleType.ADMIN.getName())) {
                return CapabilityCalculator.grantAllCapabilities();
            }
            if (!this.createRoleBasedPermissionResolver().isEnableRoleBasedAuthorization()) {
                return CapabilityCalculator.grantAllCapabilities();
            }
            List permissions = this.createRoleBasedPermissionManager().getRoleBasedPermission();
            if (permissions.size() == 0) {
                Identity.instance().logout();
                throw new AuthorizationException("This user has no permissions setup.");
            }
            if (this.invalidSecuritySerilizationSetup()) {
                Identity.instance().logout();
                throw new AuthorizationException(" Configuration error - Please refer to the Administration Guide section on installation. You must configure a key store before proceding.  ");
            }
            return new CapabilityCalculator().calcCapabilities(permissions);
        }
        if (this.invalidSecuritySerilizationSetup()) {
            throw new AuthorizationException(" Configuration error - Please refer to the Administration Guide section on installation. You must configure a key store before proceding.  ");
        }
        return CapabilityCalculator.grantAllCapabilities();
    }

    private RoleBasedPermissionManager createRoleBasedPermissionManager() {
        return (RoleBasedPermissionManager)Component.getInstance((String)"roleBasedPermissionManager");
    }

    private RoleBasedPermissionResolver createRoleBasedPermissionResolver() {
        return (RoleBasedPermissionResolver)Component.getInstance((String)"org.jboss.seam.security.roleBasedPermissionResolver");
    }

    private boolean invalidSecuritySerilizationSetup() {
        String ssecurity = System.getProperty("drools.serialization.sign");
        if (ssecurity != null && ssecurity.equalsIgnoreCase("true")) {
            for (String nextProp : serializationProperties) {
                String nextPropVal = System.getProperty(nextProp);
                if (nextPropVal != null && !nextPropVal.trim().equals("")) continue;
                return true;
            }
        }
        return false;
    }
}

