/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.ruleeditor.AssetCategoryEditor;

public class AssetCategoryEditor
extends DirtyableComposite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private MetaData data;
    private DirtyableFlexTable layout = new DirtyableFlexTable();
    private FlexTable list;
    private boolean readOnly;

    public AssetCategoryEditor(MetaData d, boolean readOnly) {
        this.data = d;
        this.list = new FlexTable();
        this.readOnly = readOnly;
        this.loadData(this.list);
        this.list.setStyleName("rule-List");
        this.layout.setWidget(0, 0, (Widget)this.list);
        if (!readOnly) {
            this.doActions();
        }
        this.initWidget((Widget)this.layout);
    }

    private void doActions() {
        VerticalPanel actions = new VerticalPanel();
        ImageButton add = new ImageButton(images.newItem());
        add.setTitle(this.constants.AddANewCategory());
        add.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        actions.add((Widget)add);
        this.layout.setWidget(0, 1, (Widget)actions);
    }

    protected void removeCategory(int idx) {
        this.data.removeCategory(idx);
        this.makeDirty();
        this.resetBox();
    }

    private void resetBox() {
        this.list = new FlexTable();
        this.list.setStyleName("rule-List");
        this.layout.setWidget(0, 0, (Widget)this.list);
        this.loadData(this.list);
        this.makeDirty();
    }

    private void loadData(FlexTable list) {
        for (int i = 0; i < this.data.getCategories().length; ++i) {
            int idx = i;
            list.setWidget(i, 0, (Widget)new SmallLabel(this.data.getCategories()[i]));
            if (this.readOnly) continue;
            ImageButton del = new ImageButton(images.trash());
            del.setTitle(this.constants.RemoveThisCategory());
            del.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            list.setWidget(i, 1, (Widget)del);
        }
    }

    private void doOKClick() {
        CategorySelector sel = new CategorySelector(this);
        sel.show();
    }

    public void addToCategory(String selectedPath) {
        this.data.addCategory(selectedPath);
        this.resetBox();
    }

    static /* synthetic */ void access$000(AssetCategoryEditor x0) {
        x0.doOKClick();
    }

    static /* synthetic */ Constants access$100(AssetCategoryEditor x0) {
        return x0.constants;
    }
}

