/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.widgets.wizards.Wizard;
import org.drools.guvnor.client.widgets.wizards.WizardActivityView;
import org.drools.guvnor.client.widgets.wizards.WizardPage;
import org.drools.guvnor.client.widgets.wizards.WizardPageSelectedEvent;
import org.drools.guvnor.client.widgets.wizards.WizardPageStatusChangeEvent;
import org.drools.guvnor.client.widgets.wizards.WizardPlace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardActivity
extends Activity
implements WizardActivityView.Presenter,
WizardPageStatusChangeEvent.Handler,
WizardPageSelectedEvent.Handler {
    private WizardActivityView view;
    private Wizard wizard;

    public WizardActivity(WizardPlace<?> place, ClientFactory clientFactory) {
        this.view = clientFactory.getNavigationViewFactory().getWizardView();
        this.wizard = clientFactory.getWizardFactory().getWizard(place.getContext(), (WizardActivityView.Presenter)this);
        this.view.setPresenter((WizardActivityView.Presenter)this);
    }

    public void onStatusChange(WizardPageStatusChangeEvent event) {
        WizardPage page = event.getSource();
        if (!this.wizard.getPages().contains(page)) {
            return;
        }
        for (WizardPage wp : this.wizard.getPages()) {
            int index = this.wizard.getPages().indexOf(wp);
            this.view.setPageCompletionState(index, wp.isComplete());
        }
        this.view.setCompletionStatus(this.wizard.isComplete());
    }

    public void onPageSelected(WizardPageSelectedEvent event) {
        WizardPage page = event.getSource();
        int index = this.wizard.getPages().indexOf(page);
        this.view.selectPage(index);
    }

    public void start(AcceptItem acceptTabItem, EventBus eventBus) {
        eventBus.addHandler(WizardPageStatusChangeEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(WizardPageSelectedEvent.TYPE, (EventHandler)this);
        this.view.setTitle(this.wizard.getTitle());
        this.view.setPreferredHeight(this.wizard.getPreferredHeight());
        this.view.setPreferredWidth(this.wizard.getPreferredWidth());
        this.view.setPageTitles(this.wizard.getPages());
        this.view.show();
        this.view.selectPage(0);
    }

    public void pageSelected(int pageNumber) {
        Widget w = this.wizard.getPageWidget(pageNumber);
        this.view.setBodyWidget(w);
    }

    public void complete() {
        this.wizard.complete();
    }

    public void showSavingIndicator() {
        this.view.showSavingIndicator();
    }

    public void hideSavingIndicator() {
        this.view.hideSavingIndicator();
    }

    public void showDuplicateAssetNameError() {
        this.view.showDuplicateAssetNameError();
    }

    public void showUnspecifiedCheckinError() {
        this.view.showUnspecifiedCheckinError();
    }

    public void showCheckinError(String message) {
        this.view.showCheckinError(message);
    }

    public void hide() {
        this.view.hide();
    }
}

