/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.drools.guvnor.client.rpc.PushResponse;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;
import org.jboss.seam.web.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Backchannel {
    private static final Backchannel instance = new Backchannel();
    private final List<CountDownLatch> waiting = Collections.synchronizedList(new ArrayList());
    private final Map<String, List<PushResponse>> mailbox = Collections.synchronizedMap(new HashMap());
    private final Timer timer = new Timer(true);

    public static Backchannel getInstance() {
        return instance;
    }

    private Backchannel() {
        this.timer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 20000L, 30000L);
    }

    public List<PushResponse> subscribe() {
        if (Contexts.isApplicationContextActive() && !Session.instance().isInvalid()) {
            try {
                return this.await(Identity.instance().getCredentials().getUsername());
            }
            catch (InterruptedException e) {
                return new ArrayList<PushResponse>();
            }
        }
        return new ArrayList<PushResponse>();
    }

    public List<PushResponse> await(String userName) throws InterruptedException {
        List messages = this.fetchMessageForUser(userName);
        if (messages != null && messages.size() > 0) {
            return messages;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.waiting.add(latch);
        latch.await(10800L, TimeUnit.SECONDS);
        return this.fetchMessageForUser(userName);
    }

    private List<PushResponse> fetchMessageForUser(String userName) {
        List msgs = (List)this.mailbox.get(userName);
        this.mailbox.put(userName, new ArrayList());
        return msgs;
    }

    public synchronized void push(String userName, PushResponse message) {
        ArrayList<PushResponse> resp = (ArrayList<PushResponse>)this.mailbox.get(userName);
        if (resp == null) {
            resp = new ArrayList<PushResponse>();
            resp.add(message);
            this.mailbox.put(userName, resp);
        } else {
            resp.add(message);
        }
        this.unlatchAllWaiting();
    }

    public synchronized void publish(PushResponse message) {
        for (Map.Entry entry : this.mailbox.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue(new ArrayList());
            }
            ((List)entry.getValue()).add(message);
        }
        this.unlatchAllWaiting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlatchAllWaiting() {
        List list = this.waiting;
        synchronized (list) {
            Iterator it = this.waiting.iterator();
            while (it.hasNext()) {
                CountDownLatch l = (CountDownLatch)it.next();
                l.countDown();
                it.remove();
            }
        }
    }

    static /* synthetic */ void access$000(Backchannel x0) {
        x0.unlatchAllWaiting();
    }
}

