/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.WorkflowProcess;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.contenthandler.BPMN2ProcessHandler;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.utils.IOUtils;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GuvnorAPIServlet
extends HttpServlet {
    private static final String INJECT = "inject";
    private static final String EXTRACT = "extract";
    private static final String LOAD = "load";
    private static final LoggingHelper log = LoggingHelper.getLogger(GuvnorAPIServlet.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Incoming request for Guvnor API:" + request.getRequestURL());
        String action = request.getParameter("action");
        if ("load".equals(action)) {
            String uuid = request.getParameter("uuid");
            if (uuid == null) {
                throw new ServletException((Throwable)new IllegalArgumentException("The load action requires the parameter uuid"));
            }
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                RuleAsset asset = RepositoryServiceServlet.getAssetService().loadRuleAsset(uuid);
                if (asset.getContent() == null) return;
                response.setContentType("application/json");
                String content = null;
                content = asset.getContent() instanceof RuleFlowContentModel ? ((RuleFlowContentModel)asset.getContent()).getXml() : asset.getContent().toString();
                try {
                    content = GuvnorAPIServlet.deserialize((String)(GuvnorAPIServlet.getDesignerURL() + "/bpmn2_0deserialization"), (String)content);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
                log.debug("Sending model");
                log.debug(content);
                log.debug("End of sending model");
                response.setContentLength(content.getBytes().length);
                outputStream.write(content.getBytes());
                return;
            }
            catch (SerializationException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            finally {
                outputStream.close();
            }
        }
        if ("extract".equals(action)) {
            String json = request.getParameter("json");
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                Map result = GuvnorAPIServlet.extract((String)json);
                response.setContentType("application/json");
                log.debug("extracting");
                String s = "";
                int i = 0;
                for (Map.Entry entry : result.entrySet()) {
                    log.debug((String)entry.getKey() + " " + ((String[])entry.getValue())[0] + " " + ((String[])entry.getValue())[1]);
                    s = s + (String)entry.getKey() + "#" + ((String[])entry.getValue())[0] + "#" + ((String[])entry.getValue())[1];
                    if (i++ == result.size() - 1) continue;
                    s = s + "###";
                }
                log.debug("End of extracting");
                response.setContentLength(s.getBytes().length);
                outputStream.write(s.getBytes());
                return;
            }
            catch (Throwable t) {
                throw new ServletException(t);
            }
            finally {
                outputStream.close();
            }
        }
        if (!"inject".equals(action)) throw new ServletException((Throwable)new IllegalArgumentException("The servlet requires a parameter named action"));
        String json = request.getParameter("json");
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            String[] constraint;
            HashMap<String, String> constraints = new HashMap<String, String>();
            for (String c : constraint = request.getParameterValues("constraint")) {
                String nodeId = c.substring(0, c.indexOf(":"));
                String rule = c.substring(c.indexOf(":") + 1);
                constraints.put(nodeId, rule);
            }
            String result = GuvnorAPIServlet.inject((String)json, constraints);
            response.setContentType("application/json");
            log.debug("injecting");
            if (log.isDebugEnabled()) {
                for (Map.Entry entry : constraints.entrySet()) {
                    log.debug((String)entry.getKey() + " " + (String)entry.getValue());
                }
            }
            log.debug(result);
            log.debug("End of injecting");
            response.setContentLength(result.getBytes().length);
            outputStream.write(result.getBytes());
            return;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deserialize(String deserializeUrl, String modelXml) throws IOException {
        String string;
        OutputStream out = null;
        InputStream content = null;
        ByteArrayOutputStream bos = null;
        try {
            URL bpmn2_0SerializationURL = new URL(deserializeUrl);
            modelXml = "data=" + URLEncoder.encode(modelXml, "UTF-8");
            byte[] bytes = modelXml.getBytes("UTF-8");
            HttpURLConnection connection = (HttpURLConnection)bpmn2_0SerializationURL.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setFixedLengthStreamingMode(bytes.length);
            connection.setDoOutput(true);
            out = connection.getOutputStream();
            out.write(bytes);
            out.close();
            content = connection.getInputStream();
            bos = new ByteArrayOutputStream();
            int b = 0;
            while ((b = content.read()) > -1) {
                bos.write(b);
            }
            bytes = bos.toByteArray();
            content.close();
            bos.close();
            string = new String(bytes);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(content);
            IOUtils.closeQuietly(bos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)content);
        IOUtils.closeQuietly((OutputStream)bos);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String[]> extract(String json) throws Exception {
        HashMap<String, String[]> result = null;
        String xml = BPMN2ProcessHandler.serialize((String)(GuvnorAPIServlet.getDesignerURL() + "/bpmn2_0serialization"), (String)json);
        StringReader isr = null;
        try {
            isr = new StringReader(xml);
            SemanticModules semanticModules = new SemanticModules();
            semanticModules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            semanticModules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(semanticModules, GuvnorAPIServlet.getClassLoader());
            List processes = xmlReader.read((Reader)isr);
            RuleFlowProcess process = null;
            if (processes.size() == 0) {
                String message = "RuleFlowProcess not found.";
                log.error("RuleFlowProcess not found.");
                throw new RuntimeException("RuleFlowProcess not found.");
            }
            if (processes.size() > 1) {
                String message = "An asset can only contain one RuleFlowProcess. Multiple were detected.";
                log.error("An asset can only contain one RuleFlowProcess. Multiple were detected.");
                throw new RuntimeException("An asset can only contain one RuleFlowProcess. Multiple were detected.");
            }
            if (!(processes.get(0) instanceof RuleFlowProcess)) {
                String message = "The asset does not contain a RuleFlowProcess. Unable to process.";
                log.error("The asset does not contain a RuleFlowProcess. Unable to process.");
                throw new RuntimeException("The asset does not contain a RuleFlowProcess. Unable to process.");
            }
            process = (RuleFlowProcess)processes.get(0);
            log.debug("Processing " + process.getId());
            result = new HashMap<String, String[]>();
            StartNode start = process.getStart();
            Node target = start.getTo().getTo();
            if (target instanceof Split) {
                Split split = (Split)target;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    Constraint constraint = split.getConstraint(connection);
                    if (constraint == null) continue;
                    System.out.println("Found constraint to node " + connection.getTo().getName() + " [" + connection.getTo().getId() + "]: " + constraint.getConstraint());
                    result.put(XmlBPMNProcessDumper.getUniqueNodeId((Node)connection.getTo()), new String[]{connection.getTo().getName(), constraint.getConstraint()});
                }
            }
            HashMap<String, String[]> hashMap = result;
            return hashMap;
        }
        finally {
            if (isr != null) {
                ((Reader)isr).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inject(String json, Map<String, String> constraints) throws Exception {
        String xml = BPMN2ProcessHandler.serialize((String)(GuvnorAPIServlet.getDesignerURL() + "/bpmn2_0serialization"), (String)json);
        StringReader isr = null;
        try {
            isr = new StringReader(xml);
            SemanticModules semanticModules = new SemanticModules();
            semanticModules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            semanticModules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(semanticModules, GuvnorAPIServlet.getClassLoader());
            List processes = xmlReader.read((Reader)isr);
            RuleFlowProcess process = null;
            if (processes.size() == 0) {
                String message = "RuleFlowProcess not found.";
                log.error("RuleFlowProcess not found.");
                throw new RuntimeException("RuleFlowProcess not found.");
            }
            if (processes.size() > 1) {
                String message = "An asset can only contain one RuleFlowProcess. Multiple were detected.";
                log.error("An asset can only contain one RuleFlowProcess. Multiple were detected.");
                throw new RuntimeException("An asset can only contain one RuleFlowProcess. Multiple were detected.");
            }
            if (!(processes.get(0) instanceof RuleFlowProcess)) {
                String message = "The asset does not contain a RuleFlowProcess. Unable to process.";
                log.error("The asset does not contain a RuleFlowProcess. Unable to process.");
                throw new RuntimeException("The asset does not contain a RuleFlowProcess. Unable to process.");
            }
            process = (RuleFlowProcess)processes.get(0);
            log.debug("Processing " + process.getId());
            StartNode start = process.getStart();
            Node target = start.getTo().getTo();
            if (target instanceof Split) {
                Split split = (Split)target;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    String s = constraints.get(XmlBPMNProcessDumper.getUniqueNodeId((Node)connection.getTo()));
                    if (s == null) continue;
                    System.out.println("Found constraint to node " + connection.getTo().getName() + ": " + s);
                    Constraint constraint = split.getConstraint(connection);
                    if (constraint == null) {
                        constraint = new ConstraintImpl();
                        split.setConstraint(connection, constraint);
                    }
                    constraint.setConstraint(s);
                }
            }
            String newXml = XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process);
            System.out.println(newXml);
            String string = GuvnorAPIServlet.deserialize((String)(GuvnorAPIServlet.getDesignerURL() + "/bpmn2_0deserialization"), (String)newXml);
            return string;
        }
        finally {
            if (isr != null) {
                ((Reader)isr).close();
            }
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = GuvnorAPIServlet.class.getClassLoader();
        }
        return cl;
    }

    private static String getDesignerURL() {
        return System.getProperty("designer.url") + "/" + System.getProperty("designer.context");
    }
}

