/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import org.drools.guvnor.client.rpc.CategoryPageRequest;
import org.drools.guvnor.client.rpc.CategoryPageRow;
import org.drools.guvnor.client.rpc.CategoryService;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.RepositoryCategoryOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.PageResponseBuilder;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.repository.RulesRepository;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.client.rpc.CategoryService")
@AutoCreate
public class RepositoryCategoryService
implements CategoryService {
    @In
    private RulesRepository repository;
    private static final long serialVersionUID = 12365L;
    private final ServiceSecurity serviceSecurity = new ServiceSecurity();
    private final RepositoryCategoryOperations repositoryCategoryOperations = new RepositoryCategoryOperations();

    @Create
    public void create() {
        this.repositoryCategoryOperations.setRulesRepository(this.getRulesRepository());
    }

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
        this.create();
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] loadChildCategories(String categoryPath) {
        return this.repositoryCategoryOperations.loadChildCategories(categoryPath);
    }

    @WebRemote
    public Boolean createCategory(String path, String name, String description) {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryCategoryOperations.createCategory(path, name, description);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void renameCategory(String fullPathAndName, String newName) {
        this.repositoryCategoryOperations.renameCategory(fullPathAndName, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public TableDataResult loadRuleListForCategories(String categoryPath, int skip, int numRows, String tableConfig) throws SerializationException {
        return this.repositoryCategoryOperations.loadRuleListForCategories(categoryPath, skip, numRows, tableConfig);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PageResponse<CategoryPageRow> loadRuleListForCategories(CategoryPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        if (!this.serviceSecurity.isSecurityIsAnalystReadWithTargetObject((Object)new CategoryPathType(request.getCategoryPath()))) {
            ArrayList rowList = new ArrayList();
            PageResponse pageResponse = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(true).buildWithTotalRowCount(-1L);
            return pageResponse;
        }
        return this.repositoryCategoryOperations.loadRuleListForCategories(request);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removeCategory(String categoryPath) throws SerializationException {
        this.repositoryCategoryOperations.removeCategory(categoryPath);
    }
}

