/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.server.builder.AssemblerBase;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.DeclaredTypesSorter;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.lang.descr.PackageDescr;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;

abstract class PackageAssemblerBase
extends AssemblerBase {
    protected PackageAssemblerBase(PackageItem packageItem) {
        super(packageItem);
    }

    protected void buildAsset(AssetItem asset) {
        ContentHandler contentHandler = ContentManager.getHandler((String)asset.getFormat());
        if (contentHandler instanceof ICompilable && !asset.getDisabled()) {
            try {
                this.compile(asset, (ICompilable)contentHandler);
            }
            catch (DroolsParserException e) {
                this.errorLogger.addError(asset, e.getMessage());
                throw new RulesRepositoryException((Throwable)e);
            }
            catch (IOException e) {
                this.errorLogger.addError(asset, e.getMessage());
            }
        }
    }

    private void compile(AssetItem asset, ICompilable contentHandler) throws DroolsParserException, IOException {
        contentHandler.compile(this.builder, asset, this.errorLogger);
        if (this.builder.hasErrors()) {
            this.logErrors(asset);
        }
    }

    protected boolean setUpPackage() {
        this.builder.addPackage(new PackageDescr(this.packageItem.getName()));
        String packageHeader = DroolsHeader.getDroolsHeader((PackageItem)this.packageItem);
        this.loadPackageHeaderDrl(DroolsHeader.getPackageHeaderImports((String)packageHeader));
        this.loadDeclaredTypes();
        this.loadPackageHeaderDrl(DroolsHeader.getPackageHeaderGlobals((String)packageHeader));
        this.loadPackageHeaderDrl(DroolsHeader.getPackageHeaderMiscellaneous((String)packageHeader));
        if (this.doesPackageBuilderHaveAnyErrors()) {
            return false;
        }
        this.loadDSLFiles();
        this.loadFunctions();
        return !this.errorLogger.hasErrors();
    }

    private boolean doesPackageBuilderHaveAnyErrors() {
        if (this.builder.hasErrors()) {
            this.recordBuilderErrors(this.packageItem.getFormat(), this.packageItem.getName(), this.packageItem.getUUID(), true, false);
            return true;
        }
        return false;
    }

    private void loadFunctions() {
        try {
            this.addDrl(this.getAllFunctionsAsOneString().toString());
        }
        catch (IOException e) {
            throw new RulesRepositoryException("Unexpected error when parsing package.", (Throwable)e);
        }
        catch (DroolsParserException e) {
            throw new RulesRepositoryException("Unexpected error when parsing package.", (Throwable)e);
        }
        if (this.builder.hasErrors()) {
            this.searchTheFunctionWithAnError();
        }
    }

    private StringBuilder getAllFunctionsAsOneString() {
        Iterator functionsIterator = this.getAssetItemIterator(new String[]{"function"});
        StringBuilder stringBuilder = new StringBuilder();
        while (functionsIterator.hasNext()) {
            AssetItem function = (AssetItem)functionsIterator.next();
            if (function.getDisabled()) continue;
            stringBuilder.append(function.getContent());
        }
        return stringBuilder;
    }

    private void searchTheFunctionWithAnError() {
        this.builder.clearErrors();
        Iterator functionsIterator = this.getAssetItemIterator(new String[]{"function"});
        while (functionsIterator.hasNext()) {
            AssetItem function = (AssetItem)functionsIterator.next();
            if (function.getDisabled()) continue;
            try {
                this.addDrl(function.getContent());
            }
            catch (IOException e) {
                this.errorLogger.addError(function, "IOException: " + e.getMessage());
            }
            catch (DroolsParserException e) {
                this.errorLogger.addError(this.packageItem, "Parser exception: " + e.getMessage());
            }
            if (!this.builder.hasErrors()) continue;
            this.logErrors(function);
        }
    }

    private void loadPackageHeaderDrl(String drl) {
        try {
            this.addDrl(drl.toString());
        }
        catch (IOException e) {
            this.errorLogger.addError(this.packageItem, "IOException: " + e.getMessage());
        }
        catch (DroolsParserException e) {
            this.errorLogger.addError(this.packageItem, "Parser exception: " + e.getMessage());
        }
    }

    private void loadDeclaredTypes() {
        ArrayList<AssetItem> assets = new ArrayList<AssetItem>();
        DeclaredTypesSorter sorter = new DeclaredTypesSorter();
        Iterator assetItemIterator = this.getAssetItemIterator(new String[]{"model.drl"});
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = (AssetItem)assetItemIterator.next();
            if (assetItem.getDisabled()) continue;
            assets.add(assetItem);
        }
        List sortedAssets = sorter.sort(assets);
        for (DeclaredTypesSorter.DeclaredTypeAssetInheritanceInformation dt : sortedAssets) {
            try {
                this.addDrl(dt.getDrl());
            }
            catch (DroolsParserException dpe) {
                this.errorLogger.addError(dt.getOwningAssetItem(), "Parser exception: " + dpe.getMessage());
            }
            catch (IOException dpe) {
                this.errorLogger.addError(dt.getOwningAssetItem(), "IOException: " + dpe.getMessage());
            }
        }
    }

    private boolean isEmpty(String content) {
        return content == null || content.trim().length() == 0;
    }

    public boolean isPackageConfigurationInError() {
        if (this.errorLogger.hasErrors()) {
            return ((ContentAssemblyError)this.errorLogger.getErrors().get(0)).isPackageItem();
        }
        return false;
    }

    private void addDrl(String drl) throws IOException, DroolsParserException {
        if (this.isEmpty(drl)) {
            return;
        }
        this.builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    private void recordBuilderErrors(String format, String name, String uuid, boolean isPackageItem, boolean isAssetItem) {
        for (DroolsError droolsError : this.builder.getErrors().getErrors()) {
            this.errorLogger.addError(droolsError.getMessage(), format, name, uuid, isPackageItem, isAssetItem);
        }
        this.builder.clearErrors();
    }

    private void logErrors(AssetItem asset) {
        this.recordBuilderErrors(asset.getFormat(), asset.getName(), asset.getUUID(), false, true);
    }
}

