/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.WebDavServletBean;
import org.drools.guvnor.server.files.RestAPIServlet;
import org.drools.guvnor.server.files.WebDAVImpl;

public class WebdavServlet
extends WebDavServletBean {
    private static final long serialVersionUID = 510L;

    public void init() throws ServletException {
        String clazzName = WebDAVImpl.class.getName();
        File root = new File("");
        IWebdavStore webdavStore = this.constructStore(clazzName, root);
        String lazyFolderCreationOnPutValue = this.getInitParameter("lazyFolderCreationOnPut");
        boolean lazyFolderCreationOnPut = lazyFolderCreationOnPutValue != null && lazyFolderCreationOnPutValue.equals("1");
        String dftIndexFile = this.getInitParameter("default-index-file");
        String insteadOf404 = this.getInitParameter("instead-of-404");
        int noContentLengthHeader = 0;
        super.init(webdavStore, dftIndexFile, insteadOf404, noContentLengthHeader, lazyFolderCreationOnPut);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String auth = req.getHeader("Authorization");
        if (!RestAPIServlet.allowUser((String)auth)) {
            resp.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
            resp.sendError(401);
        } else {
            super.service(req, resp);
        }
    }

    protected IWebdavStore constructStore(String clazzName, File root) {
        IWebdavStore webdavStore;
        try {
            Class<?> clazz = WebdavServlet.class.getClassLoader().loadClass(clazzName);
            Constructor<?> ctor = clazz.getConstructor(File.class);
            webdavStore = (IWebdavStore)ctor.newInstance(root);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("some problem making store component", e);
        }
        return webdavStore;
    }
}

