/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.ruleeditor.workitem;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkitemDefinitionElementsManager {
    private static final String WORKITEM_DEFINITION_ELEMENTS_PROPERTIES = "/workitemDefinitionElements.properties";
    private static WorkitemDefinitionElementsManager INSTANCE;
    private final Map<String, String> properties = new LinkedHashMap();

    private WorkitemDefinitionElementsManager() throws IOException {
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream(WORKITEM_DEFINITION_ELEMENTS_PROPERTIES));
        this.populateProperties(props.entrySet());
    }

    public static synchronized WorkitemDefinitionElementsManager getInstance() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new WorkitemDefinitionElementsManager();
        }
        return INSTANCE;
    }

    private void populateProperties(Set<Map.Entry<Object, Object>> fileProps) {
        for (Map.Entry<Object, Object> entry : fileProps) {
            String key = entry.getKey().toString().replaceAll("_", " ");
            this.properties.put(key, entry.getValue().toString());
        }
    }

    public Set<String> getElementNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public String getElementValue(String elementName) {
        return (String)this.properties.get(elementName);
    }

    public Map<String, String> getElements() {
        return this.properties;
    }
}

