/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.standalonededitor;

import java.util.ArrayList;
import java.util.UUID;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.standalonededitor.RuleAssetProvider;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRXMLPersistence;

public class BRLRuleAssetProvider
implements RuleAssetProvider {
    private final String packageName;
    private final String[] initialBRLs;

    public BRLRuleAssetProvider(String packageName, String[] initialBRLs) {
        this.packageName = packageName;
        this.initialBRLs = initialBRLs;
    }

    public RuleAsset[] getRuleAssets() throws DetailedSerializationException {
        ArrayList<RuleModel> models = new ArrayList<RuleModel>(this.initialBRLs.length);
        ArrayList<RuleAsset> assets = new ArrayList<RuleAsset>(this.initialBRLs.length);
        for (String brl : this.initialBRLs) {
            models.add(BRXMLPersistence.getInstance().unmarshal(brl));
        }
        try {
            for (RuleModel ruleModel : models) {
                assets.add(this.createAsset(ruleModel));
            }
        }
        catch (Exception e) {
            for (RuleAsset ruleAsset : assets) {
                this.getAssetService().removeAsset(ruleAsset.getUuid());
            }
            if (e instanceof DetailedSerializationException) {
                throw (DetailedSerializationException)e;
            }
            throw new DetailedSerializationException("Error creating assets", e.getMessage());
        }
        return assets.toArray(new RuleAsset[assets.size()]);
    }

    private RuleAsset createAsset(RuleModel ruleModel) {
        RuleAsset asset = new RuleAsset();
        asset.setUuid("mock-" + UUID.randomUUID().toString());
        asset.setContent((PortableObject)ruleModel);
        asset.setName(ruleModel.name);
        asset.setFormat("brl");
        asset.setMetaData(this.createMetaData());
        return asset;
    }

    private MetaData createMetaData() {
        MetaData metaData = new MetaData();
        metaData.setPackageName(this.packageName);
        metaData.setPackageUUID("mock");
        return metaData;
    }

    private RepositoryAssetService getAssetService() {
        return RepositoryServiceServlet.getAssetService();
    }
}

