/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BRMSSuggestionCompletionLoader
extends SuggestionCompletionLoader {
    public BRMSSuggestionCompletionLoader() {
    }

    public BRMSSuggestionCompletionLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public SuggestionCompletionEngine getSuggestionEngine(PackageItem packageItem, String droolsHeader) {
        StringBuilder buf = new StringBuilder();
        AssetItemIterator it = packageItem.listAssetsByFormat(new String[]{"model.drl"});
        while (it.hasNext()) {
            AssetItem as = it.next();
            buf.append(as.getContent());
            buf.append('\n');
        }
        ClassLoaderBuilder classLoaderBuilder = new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"}));
        return super.getSuggestionEngine(droolsHeader + "\n" + buf.toString(), classLoaderBuilder.getJarInputStreams(), this.getDSLMappingFiles(packageItem), this.getDataEnums(packageItem));
    }

    public SuggestionCompletionEngine getSuggestionEngine(PackageItem pkg) {
        return this.getSuggestionEngine(pkg, DroolsHeader.getDroolsHeader((PackageItem)pkg));
    }

    private List<String> getDataEnums(PackageItem pkg) {
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"enumeration"});
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            AssetItem item = (AssetItem)it.next();
            list.add(item.getContent());
        }
        return list;
    }

    private List<DSLTokenizedMappingFile> getDSLMappingFiles(PackageItem pkg) {
        return DSLLoader.loadDSLMappingFiles((PackageItem)pkg, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */);
    }
}

