/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import java.math.BigDecimal;
import java.util.Date;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.widgets.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableCellValueFactory
extends AbstractCellValueFactory<DTColumnConfig52> {
    private GuidedDecisionTable52 model;

    public DecisionTableCellValueFactory(SuggestionCompletionEngine sce, GuidedDecisionTable52 model) {
        super(sce);
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    public DTCellValue52 convertToDTModelCell(DTColumnConfig52 column, CellValue<?> cell) {
        DTDataTypes52 dt = this.getDataType(column);
        DTCellValue52 dtCell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dt.ordinal()]) {
            case 1: {
                dtCell = new DTCellValue52((Boolean)cell.getValue());
                break;
            }
            case 2: {
                dtCell = new DTCellValue52((Date)cell.getValue());
                break;
            }
            case 3: {
                dtCell = new DTCellValue52((BigDecimal)cell.getValue());
                break;
            }
            default: {
                dtCell = new DTCellValue52((String)((Object)cell.getValue()));
            }
        }
        dtCell.setOtherwise(cell.isOtherwise());
        return dtCell;
    }

    public CellValue<? extends Comparable<?>> makeCellValue(DTColumnConfig52 column, int iRow, int iCol, DTCellValue52 dcv) {
        DTDataTypes52 dataType = this.getDataType(column);
        CellValue cell = null;
        this.assertDTCellValue(dataType, dcv);
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 1: {
                cell = this.makeNewBooleanCellValue(iRow, iCol, dcv.getBooleanValue());
                break;
            }
            case 2: {
                cell = this.makeNewDateCellValue(iRow, iCol, dcv.getDateValue());
                break;
            }
            case 3: {
                AttributeCol52 at;
                if (column instanceof RowNumberCol52) {
                    cell = this.makeNewRowNumberCellValue(iRow, iCol);
                    break;
                }
                cell = this.makeNewNumericCellValue(iRow, iCol, dcv.getNumericValue());
                if (!(column instanceof AttributeCol52) || !(at = (AttributeCol52)column).getAttribute().equals("salience") || !at.isUseRowNumber()) break;
                cell = this.makeNewRowNumberCellValue(iRow, iCol);
                break;
            }
            default: {
                AttributeCol52 ac;
                cell = this.makeNewStringCellValue(iRow, iCol, (Object)dcv.getStringValue());
                if (!(column instanceof AttributeCol52) || !(ac = (AttributeCol52)column).getAttribute().equals("dialect")) break;
                cell = this.makeNewDialectCellValue(iRow, iCol, dcv.getStringValue());
            }
        }
        if (dcv.isOtherwise()) {
            cell.addState(CellValue.CellState.OTHERWISE);
        }
        return cell;
    }

    private void assertDTCellValue(DTDataTypes52 dataType, DTCellValue52 dcv) {
        if (dcv.getDataType().equals((Object)dataType)) {
            return;
        }
        String text = dcv.getStringValue();
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 1: {
                dcv.setBooleanValue(text == null ? null : Boolean.valueOf(text));
                break;
            }
            case 2: {
                Date d = null;
                try {
                    if (text != null) {
                        if (DATE_CONVERTOR == null) {
                            throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                        }
                        d = DATE_CONVERTOR.parse(text);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                dcv.setDateValue(d);
                break;
            }
            case 3: {
                BigDecimal bd = null;
                try {
                    if (text != null) {
                        bd = new BigDecimal(text);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                dcv.setNumericValue(bd);
            }
        }
    }

    private DTDataTypes52 derieveDataType(DTColumnConfig52 col) {
        DTDataTypes52 dataType = DTDataTypes52.STRING;
        String type = this.model.getType(col, this.sce);
        if (type == null) {
            return dataType;
        }
        String[] vals = this.model.getValueList(col, this.sce);
        if (vals.length == 0) {
            if (type.equals("Numeric")) {
                dataType = DTDataTypes52.NUMERIC;
            } else if (type.equals("Boolean")) {
                dataType = DTDataTypes52.BOOLEAN;
            } else if (type.equals("Date")) {
                dataType = DTDataTypes52.DATE;
            }
        }
        return dataType;
    }

    protected DTDataTypes52 getDataType(DTColumnConfig52 column) {
        DTDataTypes52 dataType = DTDataTypes52.STRING;
        if (column instanceof RowNumberCol52) {
            dataType = DTDataTypes52.NUMERIC;
        } else if (column instanceof AttributeCol52) {
            AttributeCol52 attrCol = (AttributeCol52)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                dataType = DTDataTypes52.NUMERIC;
            } else if (attrName.equals("enabled")) {
                dataType = DTDataTypes52.BOOLEAN;
            } else if (attrName.equals("no-loop")) {
                dataType = DTDataTypes52.BOOLEAN;
            } else if (attrName.equals("duration")) {
                dataType = DTDataTypes52.NUMERIC;
            } else if (attrName.equals("timer")) {
                dataType = DTDataTypes52.STRING;
            } else if (attrName.equals("calendars")) {
                dataType = DTDataTypes52.STRING;
            } else if (attrName.equals("auto-focus")) {
                dataType = DTDataTypes52.BOOLEAN;
            } else if (attrName.equals("lock-on-active")) {
                dataType = DTDataTypes52.BOOLEAN;
            } else if (attrName.equals("date-effective")) {
                dataType = DTDataTypes52.DATE;
            } else if (attrName.equals("date-expires")) {
                dataType = DTDataTypes52.DATE;
            } else if (attrName.equals("negate")) {
                dataType = DTDataTypes52.BOOLEAN;
            }
        } else if (column instanceof ConditionCol52) {
            dataType = this.derieveDataType(column);
        } else if (column instanceof ActionSetFieldCol52) {
            dataType = this.derieveDataType(column);
        } else if (column instanceof ActionInsertFactCol52) {
            dataType = this.derieveDataType(column);
        }
        return dataType;
    }

    protected CellValue<BigDecimal> makeNewRowNumberCellValue(int iRow, int iCol) {
        CellValue cv = new CellValue((Comparable)new BigDecimal(iRow + 1), iRow, iCol);
        return cv;
    }
}

