/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.assetviewer;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ModuleEditorPlace;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.widgets.assetviewer.AssetViewerActivity;
import org.drools.guvnor.client.widgets.assetviewer.AssetViewerActivityView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AssetViewerActivity
extends Activity
implements AssetViewerActivityView.Presenter {
    private final ClientFactory clientFactory;
    private PackageConfigData packageConfigData;
    private AssetViewerActivityView view;
    private String uuid;

    public AssetViewerActivity(String uuid, ClientFactory clientFactory) {
        this.uuid = uuid;
        this.clientFactory = clientFactory;
        this.view = clientFactory.getAssetViewerActivityView();
    }

    public void start(AcceptItem acceptTabItem, EventBus eventBus) {
        this.view.showLoadingPackageInformationMessage();
        acceptTabItem.add(null, (IsWidget)this.view);
        this.clientFactory.getPackageService().loadPackageConfig(this.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void viewPackageDetail(PackageConfigData packageConfigData) {
        this.clientFactory.getPlaceController().goTo((Place)new ModuleEditorPlace(packageConfigData.getUuid()));
    }

    private void fillModuleItemStructure() {
        String[] registeredFormats = this.clientFactory.getPerspectiveFactory().getRegisteredAssetEditorFormats(this.packageConfigData.getFormat());
        ArrayList<FormatList> formatListGroupedByTitles = new ArrayList<FormatList>();
        for (String format : registeredFormats) {
            boolean found = false;
            for (FormatList formatListWithSameTitle : formatListGroupedByTitles) {
                found = FormatList.access$300((FormatList)formatListWithSameTitle, (String)format);
                if (!found) continue;
                formatListWithSameTitle.add(format);
                break;
            }
            if (found) continue;
            FormatList formatListWithSameTile = new FormatList(this);
            formatListWithSameTile.add(format);
            formatListGroupedByTitles.add(formatListWithSameTile);
        }
        this.addTitleItems(formatListGroupedByTitles);
    }

    private void addTitleItems(List<FormatList> formatListGroupedByTitles) {
        AssetGroupSemaphore s = new AssetGroupSemaphore(formatListGroupedByTitles.size());
        AssetViewerSection[] sections = new AssetViewerSection[formatListGroupedByTitles.size()];
        for (int i = 0; i < formatListGroupedByTitles.size(); ++i) {
            FormatList formatList = formatListGroupedByTitles.get(i);
            int sectionIndex = i;
            if (formatList.size() == 0) continue;
            List formatsInList = this.getFormatsInList(formatList);
            Boolean formatIsRegistered = this.getFormatIsRegistered(formatList);
            AssetPageRequest request = new AssetPageRequest(this.packageConfigData.getUuid(), formatsInList, formatIsRegistered);
            this.clientFactory.getAssetService().getAssetCount(request, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private List<String> getFormatsInList(FormatList formatList) {
        List<String> formatsInList = null;
        if (formatList.getFormats() != null && formatList.getFormats().length > 0) {
            formatsInList = Arrays.asList(formatList.getFormats());
        }
        return formatsInList;
    }

    private Boolean getFormatIsRegistered(FormatList formatList) {
        Boolean formatIsRegistered = null;
        if (formatList.getFormats() == null || formatList.getFormats().length == 0) {
            formatIsRegistered = false;
        }
        return formatIsRegistered;
    }

    private String getGroupTitle(String format) {
        return this.clientFactory.getAssetEditorFactory().getAssetEditorTitle(format);
    }

    private Image getGroupIcon(String format) {
        return this.clientFactory.getAssetEditorFactory().getAssetEditorIcon(format);
    }

    static /* synthetic */ PackageConfigData access$002(AssetViewerActivity x0, PackageConfigData x1) {
        x0.packageConfigData = x1;
        return x0.packageConfigData;
    }

    static /* synthetic */ PackageConfigData access$000(AssetViewerActivity x0) {
        return x0.packageConfigData;
    }

    static /* synthetic */ void access$100(AssetViewerActivity x0) {
        x0.fillModuleItemStructure();
    }

    static /* synthetic */ AssetViewerActivityView access$200(AssetViewerActivity x0) {
        return x0.view;
    }

    static /* synthetic */ String access$400(AssetViewerActivity x0, String x1) {
        return x0.getGroupTitle(x1);
    }

    static /* synthetic */ Image access$500(AssetViewerActivity x0, String x1) {
        return x0.getGroupIcon(x1);
    }

    static /* synthetic */ ClientFactory access$600(AssetViewerActivity x0) {
        return x0.clientFactory;
    }
}

