/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rulelist.OpenItemCommand;
import org.drools.guvnor.client.widgets.tables.PermissionsPagedTablePresenter;
import org.drools.guvnor.client.widgets.tables.PermissionsPagedTableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsPagedTablePresenter
implements PermissionsPagedTableView.Presenter {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    protected RepositoryServiceAsync repositoryService = RepositoryServiceFactory.getService();
    private final PermissionsPagedTableView view;

    public PermissionsPagedTablePresenter(PermissionsPagedTableView view) {
        this.view = view;
        this.bind();
    }

    public void bind() {
        1 newUserCommand = new /* Unavailable Anonymous Inner Class!! */;
        this.view.setNewUserCommand((Command)newUserCommand);
        2 deleteUserCommand = new /* Unavailable Anonymous Inner Class!! */;
        this.view.setDeleteUserCommand((Command)deleteUserCommand);
        3 openSelectedCommand = new /* Unavailable Anonymous Inner Class!! */;
        this.view.setOpenSelectedCommand((OpenItemCommand)openSelectedCommand);
        4 dataProvider = new /* Unavailable Anonymous Inner Class!! */;
        this.view.setDataProvider((AsyncDataProvider)dataProvider);
    }

    private void showEditor(String userName) {
        LoadingPopup.showMessage((String)this.constants.LoadingUsersPermissions());
        RepositoryServiceFactory.getService().retrieveUserPermissions(userName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doPermissionEditor(String userName, Map<String, List<String>> perms) {
        FormStylePopup editor = new FormStylePopup(images.management(), this.constants.EditUser0(userName));
        editor.addRow((Widget)new HTML("<i>" + this.constants.UserAuthenticationTip() + "</i>"));
        VerticalPanel vp = new VerticalPanel();
        editor.addAttribute("", this.doPermsPanel(perms, (Panel)vp));
        HorizontalPanel hp = new HorizontalPanel();
        Button save = new Button(this.constants.SaveChanges());
        hp.add((Widget)save);
        editor.addAttribute("", (Widget)hp);
        save.addClickHandler(this.createClickHandlerForSaveButton(userName, perms, editor));
        Button cancel = new Button(this.constants.Cancel());
        hp.add((Widget)cancel);
        cancel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        editor.show();
    }

    private ClickHandler createClickHandlerForSaveButton(String userName, Map<String, List<String>> perms, FormStylePopup editor) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Widget doPermsPanel(Map<String, List<String>> perms, Panel vp) {
        vp.clear();
        for (Map.Entry<String, List<String>> perm : perms.entrySet()) {
            if (perm.getKey().equals("admin")) {
                HorizontalPanel h = new HorizontalPanel();
                h.add((Widget)new HTML("<b>" + this.constants.ThisUserIsAnAdministrator() + "</b>"));
                Button del = new Button(this.constants.RemoveAdminRights());
                del.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                h.add((Widget)del);
                vp.add((Widget)h);
                continue;
            }
            String permType = perm.getKey();
            List<String> permList = perm.getValue();
            Grid g = new Grid(permList.size() + 1, 3);
            g.setWidget(0, 0, (Widget)new HTML("<b>[" + permType + "] for:</b>"));
            for (int i = 0; i < permList.size(); ++i) {
                String p = permList.get(i);
                ImageButton del = new ImageButton(GuvnorImages.INSTANCE.DeleteItemSmall(), this.constants.RemovePermission(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                g.setWidget(i + 1, 1, (Widget)new SmallLabel(p));
                g.setWidget(i + 1, 2, (Widget)del);
            }
            vp.add((Widget)g);
        }
        ImageButton newPermission = new ImageButton(GuvnorImages.INSTANCE.NewItem(), this.constants.AddANewPermission(), this.createClickHandlerForNewPersmissionImageButton(perms, vp));
        vp.add((Widget)newPermission);
        return vp;
    }

    private ClickHandler createClickHandlerForNewPersmissionImageButton(Map<String, List<String>> perms, Panel vp) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Images access$000() {
        return images;
    }

    static /* synthetic */ Constants access$100(PermissionsPagedTablePresenter x0) {
        return x0.constants;
    }

    static /* synthetic */ PermissionsPagedTableView access$200(PermissionsPagedTablePresenter x0) {
        return x0.view;
    }

    static /* synthetic */ void access$300(PermissionsPagedTablePresenter x0, String x1) {
        x0.showEditor(x1);
    }

    static /* synthetic */ void access$400(PermissionsPagedTablePresenter x0, String x1, Map x2) {
        x0.doPermissionEditor(x1, x2);
    }

    static /* synthetic */ Widget access$500(PermissionsPagedTablePresenter x0, Map x1, Panel x2) {
        return x0.doPermsPanel(x1, x2);
    }
}

