/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards.assets.decisiontable;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.widgets.wizards.assets.decisiontable.RowExpander;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowExpander {
    private Map<DTColumnConfig52, ColumnValues> expandedColumns = new IdentityHashMap();
    private List<ColumnValues> columns = new ArrayList();
    private GuidedDecisionTable52 dtable;
    private SuggestionCompletionEngine sce;
    private static final String[] EMPTY_VALUES = new String[0];

    RowExpander(GuidedDecisionTable52 dtable, SuggestionCompletionEngine sce) {
        this.dtable = dtable;
        this.sce = sce;
        this.addRowNumberColumn();
        this.addRowDescriptionColumn();
        this.addConditionColumns();
        this.addActionColumns();
    }

    List<ColumnValues> getColumns() {
        return this.columns;
    }

    private void addRowNumberColumn() {
        ColumnValues cv = new ColumnValues(this.columns, EMPTY_VALUES, null);
        cv.setExpandColumn(false);
        this.expandedColumns.put(this.dtable.getRowNumberCol(), cv);
        this.columns.add(cv);
    }

    private void addRowDescriptionColumn() {
        ColumnValues cv = new ColumnValues(this.columns, EMPTY_VALUES, null);
        cv.setExpandColumn(false);
        this.expandedColumns.put(this.dtable.getDescriptionCol(), cv);
        this.columns.add(cv);
    }

    private void addConditionColumns() {
        for (Pattern52 p : this.dtable.getConditionPatterns()) {
            this.addColumn(p);
        }
    }

    private void addActionColumns() {
        for (ActionCol52 a : this.dtable.getActionCols()) {
            if (a instanceof ActionSetFieldCol52) {
                ActionSetFieldCol52 afc = (ActionSetFieldCol52)a;
                this.addColumn(afc);
                continue;
            }
            if (!(a instanceof ActionInsertFactCol52)) continue;
            ActionInsertFactCol52 aif = (ActionInsertFactCol52)a;
            this.addColumn(aif);
        }
    }

    private void addColumn(Pattern52 p) {
        for (ConditionCol52 c : p.getConditions()) {
            this.addColumn(c);
        }
    }

    private void addColumn(ConditionCol52 c) {
        String[] values = this.dtable.getValueList((DTColumnConfig52)c, this.sce);
        values = this.getValues(values);
        ColumnValues cv = new ColumnValues(this.columns, values, c.getDefaultValue());
        this.expandedColumns.put(c, cv);
        this.columns.add(cv);
    }

    private String[] getValues(String[] values) {
        String[] splitValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            String[] splut = ConstraintValueEditorHelper.splitValue((String)v);
            splitValues[i] = splut[0];
        }
        return splitValues;
    }

    private void addColumn(ActionSetFieldCol52 a) {
        ColumnValues cv = new ColumnValues(this.columns, EMPTY_VALUES, a.getDefaultValue());
        cv.setExpandColumn(false);
        this.expandedColumns.put(a, cv);
        this.columns.add(cv);
    }

    private void addColumn(ActionInsertFactCol52 a) {
        ColumnValues cv = new ColumnValues(this.columns, EMPTY_VALUES, a.getDefaultValue());
        cv.setExpandColumn(false);
        this.expandedColumns.put(a, cv);
        this.columns.add(cv);
    }

    RowIterator iterator() {
        return new RowIterator(this);
    }

    void setExpandColumn(DTColumnConfig52 column, boolean expandColumn) {
        ColumnValues cv = (ColumnValues)this.expandedColumns.get(column);
        if (cv == null) {
            return;
        }
        cv.setExpandColumn(expandColumn);
    }

    static /* synthetic */ List access$000(RowExpander x0) {
        return x0.columns;
    }
}

