/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.List;
import org.drools.guvnor.client.rpc.AbstractPageRow;
import org.drools.guvnor.client.rpc.PageResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageResponseBuilder<T extends AbstractPageRow> {
    private final PageResponse<T> pageResponse = new PageResponse();

    public PageResponseBuilder<T> withStartRowIndex(int startRowIndex) {
        this.pageResponse.setStartRowIndex(startRowIndex);
        return this;
    }

    public PageResponseBuilder<T> withPageRowList(List<T> assetPageRowList) {
        this.pageResponse.setPageRowList(assetPageRowList);
        return this;
    }

    public PageResponseBuilder<T> withLastPage(boolean isLastPage) {
        this.pageResponse.setLastPage(isLastPage);
        return this;
    }

    public PageResponseBuilder<T> withTotalRowSize(int totalRowSize) {
        this.pageResponse.setTotalRowSize(totalRowSize);
        return this;
    }

    public PageResponseBuilder<T> withTotalRowSizeHelper(int totalRowCount) {
        this.fixTotalRowSize((long)totalRowCount);
        return this;
    }

    public PageResponseBuilder<T> withTotalRowSizeExact() {
        this.pageResponse.setTotalRowSizeExact(true);
        return this;
    }

    public void fixTotalRowSize(long totalRowsCount) {
        if (totalRowsCount > Integer.MAX_VALUE) {
            throw new IllegalStateException("The totalRowSize (" + totalRowsCount + ") is too big.");
        }
        if (totalRowsCount == -1L) {
            if (this.pageResponse.isLastPage()) {
                this.pageResponse.setTotalRowSize(this.pageResponse.getStartRowIndex() + this.pageResponse.getPageRowList().size());
                this.pageResponse.setTotalRowSizeExact(true);
            } else {
                this.pageResponse.setTotalRowSize(-1);
                this.pageResponse.setTotalRowSizeExact(false);
            }
        } else {
            this.pageResponse.setTotalRowSize((int)totalRowsCount);
            this.pageResponse.setTotalRowSizeExact(true);
        }
    }

    public PageResponse<T> build() {
        return this.pageResponse;
    }

    public PageResponse<T> buildWithTotalRowCount(long totalRowCount) {
        this.fixTotalRowSize(totalRowCount);
        return this.pageResponse;
    }
}

