/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

public class WorkspaceManager
extends Composite {
    private static Images images = (Images)GWT.create(Images.class);
    private Constants constants = (Constants)GWT.create(Constants.class);
    private ListBox availableWorkspacesListBox;
    private ListBox availableModulesListBox = new ListBox(true);
    private ListBox selectedModulesListBox = new ListBox(true);

    public WorkspaceManager() {
        PrettyFormLayout form = new PrettyFormLayout();
        form.addHeader(GuvnorImages.INSTANCE.WorkspaceManager(), (Widget)new HTML("<b>" + this.constants.ManageWorkspaces() + "</b>"));
        form.startSection(this.constants.Workspaces());
        form.addAttribute("", (Widget)this.buildDoubleList());
        HorizontalPanel hPanel = new HorizontalPanel();
        Button create = new Button(this.constants.AddWorkspace());
        create.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button remove = new Button(this.constants.DeleteSelectedWorkspace());
        remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button updateWorkspace = new Button(this.constants.UpdateSelectedWorkspace());
        updateWorkspace.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)create);
        hPanel.add((Widget)remove);
        hPanel.add((Widget)updateWorkspace);
        form.addAttribute("", (Widget)hPanel);
        form.endSection();
        this.initWidget((Widget)form);
    }

    private void removeWorkspace() {
        String name = this.availableWorkspacesListBox.getItemText(this.availableWorkspacesListBox.getSelectedIndex());
        RepositoryServiceFactory.getService().removeWorkspace(name, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateWorkspace() {
        String name = this.availableWorkspacesListBox.getItemText(this.availableWorkspacesListBox.getSelectedIndex());
        ArrayList<String> selectedModulesList = new ArrayList<String>(this.selectedModulesListBox.getItemCount());
        for (int i = 0; i < this.selectedModulesListBox.getItemCount(); ++i) {
            selectedModulesList.add(this.selectedModulesListBox.getItemText(i));
        }
        ArrayList<String> availableModuleList = new ArrayList<String>(this.availableModulesListBox.getItemCount());
        for (int i = 0; i < this.availableModulesListBox.getItemCount(); ++i) {
            availableModuleList.add(this.availableModulesListBox.getItemText(i));
        }
        availableModuleList.removeAll(selectedModulesList);
        LoadingPopup.showMessage((String)this.constants.LoadingStatuses());
        RepositoryServiceFactory.getService().updateWorkspace(name, selectedModulesList.toArray(new String[selectedModulesList.size()]), availableModuleList.toArray(new String[availableModuleList.size()]), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void refreshWorkspaceList() {
        LoadingPopup.showMessage((String)this.constants.LoadingWorkspaces());
        RepositoryServiceFactory.getService().listWorkspaces((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void refreshModuleList(String selectedWorkspaceName) {
        if (selectedWorkspaceName == null || "".equals(selectedWorkspaceName)) {
            return;
        }
        LoadingPopup.showMessage((String)this.constants.LoadingWorkspaces());
        RepositoryServiceFactory.getPackageService().listPackages(selectedWorkspaceName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        LoadingPopup.showMessage((String)this.constants.LoadingWorkspaces());
        RepositoryServiceFactory.getPackageService().listPackages((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grid buildDoubleList() {
        Grid grid = new Grid(2, 5);
        this.availableWorkspacesListBox = new ListBox();
        this.availableWorkspacesListBox.setVisibleItemCount(10);
        this.availableWorkspacesListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshWorkspaceList();
        this.availableModulesListBox.setVisibleItemCount(10);
        this.selectedModulesListBox.setVisibleItemCount(10);
        Grid btnsPanel = new Grid(2, 1);
        btnsPanel.setWidget(0, 0, (Widget)new Button(">", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        btnsPanel.setWidget(1, 0, (Widget)new Button("&lt;", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        grid.setWidget(0, 0, (Widget)new SmallLabel(this.constants.Workspaces()));
        grid.setWidget(0, 2, (Widget)new SmallLabel("Workspace: Available Modules"));
        grid.setWidget(0, 3, (Widget)new SmallLabel(""));
        grid.setWidget(0, 4, (Widget)new SmallLabel("Workspace: Selected Modules"));
        grid.setWidget(1, 0, (Widget)this.availableWorkspacesListBox);
        grid.setWidget(1, 2, (Widget)this.availableModulesListBox);
        grid.setWidget(1, 3, (Widget)btnsPanel);
        grid.setWidget(1, 4, (Widget)this.selectedModulesListBox);
        grid.getColumnFormatter().setWidth(0, "25%");
        grid.getColumnFormatter().setWidth(1, "10%");
        grid.getColumnFormatter().setWidth(2, "25%");
        grid.getColumnFormatter().setWidth(3, "15%");
        grid.getColumnFormatter().setWidth(4, "25%");
        Grid grid2 = grid;
        return grid2;
    }

    private void copySelected(ListBox from, ListBox to) {
        int selected;
        while ((selected = from.getSelectedIndex()) != -1) {
            to.addItem(from.getItemText(selected));
            from.removeItem(selected);
        }
    }

    static /* synthetic */ void access$000(WorkspaceManager x0) {
        x0.refreshWorkspaceList();
    }

    static /* synthetic */ ListBox access$100(WorkspaceManager x0) {
        return x0.availableWorkspacesListBox;
    }

    static /* synthetic */ Constants access$200(WorkspaceManager x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$300(WorkspaceManager x0) {
        x0.removeWorkspace();
    }

    static /* synthetic */ void access$400(WorkspaceManager x0) {
        x0.updateWorkspace();
    }

    static /* synthetic */ ListBox access$500(WorkspaceManager x0) {
        return x0.selectedModulesListBox;
    }

    static /* synthetic */ ListBox access$600(WorkspaceManager x0) {
        return x0.availableModulesListBox;
    }

    static /* synthetic */ void access$700(WorkspaceManager x0, String x1) {
        x0.refreshModuleList(x1);
    }

    static /* synthetic */ void access$800(WorkspaceManager x0, ListBox x1, ListBox x2) {
        x0.copySelected(x1, x2);
    }
}

