/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.DatePickerTextBox;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.util.NumbericFilterKeyPressHandler;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class FieldDataConstraintEditor
extends DirtyableComposite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private String factType;
    private FieldData field;
    private FactData givenFact;
    private final Panel panel;
    private Scenario scenario;
    private ExecutionTrace executionTrace;
    private SuggestionCompletionEngine sce;
    private ValueChanged callback;
    private IsWidget valueEditorWidget;
    private List<FieldDataConstraintEditor> dependentEnumEditors = null;

    public FieldDataConstraintEditor(String factType, ValueChanged callback, FieldData field, FactData givenFact, SuggestionCompletionEngine sce, Scenario scenario, ExecutionTrace exec) {
        this.field = field;
        this.sce = sce;
        this.factType = factType;
        this.callback = callback;
        this.scenario = scenario;
        this.executionTrace = exec;
        this.givenFact = givenFact;
        this.panel = new SimplePanel();
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void refreshEditor() {
        String key = this.factType + "." + this.field.getName();
        String flType = this.sce.getFieldType(key);
        this.panel.clear();
        if (flType != null && flType.equals("Numeric")) {
            this.valueEditorWidget = this.editableNumericTextBox(this.callback, this.field.getName(), this.field.getValue());
            this.panel.add(this.valueEditorWidget);
        } else if (flType != null && flType.equals("Boolean")) {
            this.valueEditorWidget = this.booleanEditor();
            this.panel.add(this.valueEditorWidget);
        } else if (flType != null && flType.equals("Date")) {
            this.valueEditorWidget = this.dateEditor();
            this.panel.add(this.valueEditorWidget);
        } else {
            HashMap<String, String> currentValueMap = new HashMap<String, String>();
            for (FieldData otherFieldData : this.givenFact.getFieldData()) {
                currentValueMap.put(otherFieldData.getName(), otherFieldData.getValue());
            }
            DropDownData dropDownData = this.sce.getEnums(this.factType, this.field.getName(), currentValueMap);
            if (dropDownData != null) {
                this.field.setNature(4L);
                this.dependentEnumEditors = new ArrayList();
                this.valueEditorWidget = this.dropDownEditor(dropDownData);
                this.panel.add(this.valueEditorWidget);
            } else {
                if (this.field.getValue() != null && this.field.getValue().length() > 0 && this.field.getNature() == 0L) {
                    if (this.field.getValue().length() > 1 && this.field.getValue().charAt(1) == '[' && this.field.getValue().charAt(0) == '=') {
                        this.field.setNature(1L);
                    } else if (this.field.getValue().charAt(0) == '=') {
                        this.field.setNature(2L);
                    } else {
                        this.field.setNature(1L);
                    }
                }
                if (this.field.getNature() == 0L && (this.isThereABoundVariableToSet() || this.isItAList())) {
                    Image clickme = GuvnorImages.INSTANCE.Edit();
                    clickme.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                    this.panel.add((Widget)clickme);
                } else if (this.field.getNature() == 2L) {
                    this.panel.add(this.variableEditor(this.callback));
                } else if (this.field.getNature() == 6L) {
                    this.panel.add(this.listEditor(this.callback));
                } else {
                    this.panel.add((Widget)this.editableTextBox(this.callback, this.field.getName(), this.field.getValue()));
                }
            }
        }
    }

    private TextBox editableNumericTextBox(ValueChanged changed, String fieldName, String initialValue) {
        TextBox textBox = this.editableTextBox(changed, fieldName, initialValue);
        textBox.addKeyPressHandler((KeyPressHandler)new NumbericFilterKeyPressHandler(textBox));
        return textBox;
    }

    private TextBox editableTextBox(ValueChanged changed, String fieldName, String initialValue) {
        TextBox tb = new TextBox();
        tb.setText(initialValue);
        String m = ((Constants)GWT.create(Constants.class)).ValueFor0(fieldName);
        tb.setTitle(m);
        tb.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return tb;
    }

    private EnumDropDown booleanEditor() {
        return new EnumDropDown(this.field.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, DropDownData.create((String[])new String[]{"true", "false"}));
    }

    private EnumDropDown dropDownEditor(DropDownData dropDownData) {
        return new EnumDropDown(this.field.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, dropDownData);
    }

    private DatePickerTextBox dateEditor() {
        DatePickerTextBox editor = new DatePickerTextBox(this.field.getValue());
        editor.setTitle(Constants.INSTANCE.ValueFor0(this.field.getName()));
        editor.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
        return editor;
    }

    private Widget variableEditor(ValueChanged changed) {
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        ListBox box = new ListBox();
        if (this.field.getValue() == null) {
            box.addItem(this.constants.Choose());
        }
        int j = 0;
        for (int i = 0; i < vars.size(); ++i) {
            String var = (String)vars.get(i);
            FactData f = (FactData)this.scenario.getFactTypes().get(var);
            String fieldType = null;
            fieldType = this.field.collectionType == null ? this.sce.getFieldType(this.factType, this.field.getName()) : this.field.collectionType;
            if (!f.getType().equals(fieldType)) continue;
            if (box.getItemCount() == 0) {
                box.addItem("...");
                ++j;
            }
            box.addItem("=" + var);
            if (this.field.getValue() != null && this.field.getValue().equals("=" + var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget listEditor(ValueChanged changed) {
        VerticalPanel panel = new VerticalPanel();
        int i = 0;
        for (FieldData f : this.field.collectionFieldList) {
            DirtyableHorizontalPane hpanel = new DirtyableHorizontalPane();
            FieldDataConstraintEditor fieldElement = new FieldDataConstraintEditor(f.collectionType, (ValueChanged)new /* Unavailable Anonymous Inner Class!! */, f, this.givenFact, this.sce, this.scenario, this.executionTrace);
            hpanel.add((Widget)fieldElement);
            int index = i++;
            ImageButton del = new ImageButton(GuvnorImages.INSTANCE.DeleteItemSmall(), this.constants.AElementToDelInCollectionList(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)del);
            ImageButton addPattern = new ImageButton(GuvnorImages.INSTANCE.NewItemBelow());
            addPattern.setTitle(this.constants.AddElementBelow());
            addPattern.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)addPattern);
            ImageButton moveDown = new ImageButton(GuvnorImages.INSTANCE.SuffleDown());
            moveDown.setTitle(this.constants.MoveDownListMove());
            moveDown.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)moveDown);
            ImageButton moveUp = new ImageButton(GuvnorImages.INSTANCE.SuffleUp());
            moveUp.setTitle(this.constants.MoveUpList());
            moveUp.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)moveUp);
            panel.add((Widget)hpanel);
        }
        if (this.field.collectionFieldList.size() == 0) {
            ImageButton add = new ImageButton(GuvnorImages.INSTANCE.NewItem(), this.constants.AElementToAddInCollectionList(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            panel.add((Widget)add);
        }
        return panel;
    }

    private void calculateValueFromList() {
        if (this.field.collectionFieldList == null || this.field.collectionFieldList.isEmpty()) {
            this.field.setValue("=[]");
            return;
        }
        StringBuilder listContent = new StringBuilder();
        for (FieldData f : this.field.collectionFieldList) {
            listContent.append(',');
            if (f.getValue() == null) continue;
            listContent.append(f.getValue());
        }
        this.field.setValue("=[" + listContent.substring(1) + "]");
    }

    private void showTypeChoice(ClickEvent w, FieldData con) {
        Button variable;
        FormStylePopup form = new FormStylePopup(images.newexWiz(), this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(this.constants.LiteralValue(), this.constants.LiteralValTip())));
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(this.constants.AdvancedOptions()));
        if (this.isThereABoundVariableToSet()) {
            variable = new Button(this.constants.BoundVariable());
            variable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.ABoundVariable(), this.constants.BoundVariableTip())));
        }
        if (this.isItAList()) {
            variable = new Button(this.constants.GuidedList());
            variable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.AGuidedList(), this.constants.AGuidedListTip())));
        }
        form.show();
    }

    private boolean isThereABoundVariableToSet() {
        boolean retour = false;
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        if (vars.size() > 0) {
            for (int i = 0; i < vars.size(); ++i) {
                String var = (String)vars.get(i);
                FactData f = (FactData)this.scenario.getFactTypes().get(var);
                String fieldType = null;
                fieldType = this.field.collectionType == null ? this.sce.getFieldType(this.factType, this.field.getName()) : this.field.collectionType;
                if (!f.getType().equals(fieldType)) continue;
                retour = true;
                break;
            }
        }
        return retour;
    }

    private boolean isItAList() {
        boolean retour = false;
        String fieldType = this.sce.getFieldType(this.factType, this.field.getName());
        if (fieldType != null && fieldType.equals("Collection")) {
            retour = true;
        }
        return retour;
    }

    private void doTypeChosen(FormStylePopup form) {
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    public void addIfDependentEnumEditor(FieldDataConstraintEditor candidateDependentEnumEditor) {
        if (this.isDependentEnum(candidateDependentEnumEditor)) {
            this.dependentEnumEditors.add(candidateDependentEnumEditor);
        }
    }

    public boolean isDependentEnum(FieldDataConstraintEditor child) {
        if (!this.factType.equals(child.factType)) {
            return false;
        }
        return this.sce.isDependentEnum(this.factType, this.field.getName(), child.field.getName());
    }

    private void refreshDropDownData() {
        if (this.valueEditorWidget instanceof EnumDropDown) {
            EnumDropDown dropdown = (EnumDropDown)this.valueEditorWidget;
            HashMap<String, String> currentValueMap = new HashMap<String, String>();
            for (FieldData otherFieldData : this.givenFact.getFieldData()) {
                currentValueMap.put(otherFieldData.getName(), otherFieldData.getValue());
            }
            DropDownData dropDownData = this.sce.getEnums(this.factType, this.field.getName(), currentValueMap);
            dropdown.setDropDownData(this.field.getValue(), dropDownData);
        }
    }

    static /* synthetic */ FieldData access$000(FieldDataConstraintEditor x0) {
        return x0.field;
    }

    static /* synthetic */ void access$100(FieldDataConstraintEditor x0, ClickEvent x1, FieldData x2) {
        x0.showTypeChoice(x1, x2);
    }

    static /* synthetic */ ValueChanged access$200(FieldDataConstraintEditor x0) {
        return x0.callback;
    }

    static /* synthetic */ List access$300(FieldDataConstraintEditor x0) {
        return x0.dependentEnumEditors;
    }

    static /* synthetic */ void access$400(FieldDataConstraintEditor x0) {
        x0.refreshDropDownData();
    }

    static /* synthetic */ void access$500(FieldDataConstraintEditor x0) {
        x0.calculateValueFromList();
    }

    static /* synthetic */ void access$600(FieldDataConstraintEditor x0) {
        x0.refreshEditor();
    }

    static /* synthetic */ void access$700(FieldDataConstraintEditor x0, FormStylePopup x1) {
        x0.doTypeChosen(x1);
    }

    static /* synthetic */ String access$800(FieldDataConstraintEditor x0) {
        return x0.factType;
    }

    static /* synthetic */ SuggestionCompletionEngine access$900(FieldDataConstraintEditor x0) {
        return x0.sce;
    }
}

