/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.messages.Constants;

public class DatePickerPopUp
extends PopupPanel {
    private Label timeColonLabel = new Label(":");
    private Label timeHyphenLabel = new Label(" - ");
    protected boolean showTime = false;
    protected ListBox years = new ListBox();
    protected ListBox months = new ListBox();
    protected ListBox dates = new ListBox();
    protected ListBox hours = new ListBox();
    protected ListBox minutes = new ListBox();

    public DatePickerPopUp(ClickHandler okClickHandler, DateTimeFormat formatter) {
        int year;
        this.setGlassEnabled(true);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        Date now = new Date();
        for (int i = year = now.getYear() + 1900 - 50; i < year + 100; ++i) {
            this.years.addItem(Integer.toString(i));
        }
        this.years.setSelectedIndex(50);
        horizontalPanel.add((Widget)this.years);
        Constants constants = (Constants)GWT.create(Constants.class);
        this.months.addItem(constants.January());
        this.months.addItem(constants.February());
        this.months.addItem(constants.March());
        this.months.addItem(constants.April());
        this.months.addItem(constants.May());
        this.months.addItem(constants.June());
        this.months.addItem(constants.July());
        this.months.addItem(constants.August());
        this.months.addItem(constants.September());
        this.months.addItem(constants.October());
        this.months.addItem(constants.November());
        this.months.addItem(constants.December());
        this.months.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        horizontalPanel.add((Widget)this.months);
        this.fillDates();
        horizontalPanel.add((Widget)this.dates);
        this.showTime = this.hasTime(formatter);
        if (this.showTime) {
            int i;
            for (i = 0; i < 24; ++i) {
                this.hours.addItem(Integer.toString(i));
            }
            horizontalPanel.add((Widget)this.timeHyphenLabel);
            horizontalPanel.add((Widget)this.hours);
            for (i = 0; i < 60; ++i) {
                this.minutes.addItem(Integer.toString(i));
            }
            horizontalPanel.add((Widget)this.timeColonLabel);
            horizontalPanel.add((Widget)this.minutes);
        }
        Button okButton = new Button(constants.OK());
        okButton.addClickHandler(okClickHandler);
        horizontalPanel.add((Widget)okButton);
        this.add((Widget)horizontalPanel);
    }

    private boolean hasTime(DateTimeFormat formatter) {
        return formatter.getPattern().contains("h") || formatter.getPattern().contains("H") || formatter.getPattern().contains("k") || formatter.getPattern().contains("K");
    }

    private void setTimeVisible(boolean visible) {
        this.hours.setVisible(visible);
        this.minutes.setVisible(visible);
        this.timeHyphenLabel.setVisible(visible);
        this.timeColonLabel.setVisible(visible);
    }

    public void setDropdowns(DateTimeFormat formatter, String text) {
        Date date;
        try {
            date = formatter.parse(text);
        }
        catch (Exception e) {
            date = new Date();
        }
        this.years.clear();
        int year = date.getYear() + 1900 - 50;
        for (int i = 0; i < 100; ++i) {
            this.years.addItem(Integer.toString(year));
            if (year == date.getYear() + 1900) {
                this.years.setSelectedIndex(i);
            }
            ++year;
        }
        this.months.setSelectedIndex(date.getMonth());
        this.dates.setSelectedIndex(date.getDate() - 1);
        this.setTimeVisible(this.showTime);
        if (this.showTime) {
            this.hours.setSelectedIndex(date.getHours());
            this.minutes.setSelectedIndex(date.getMinutes());
        }
    }

    private void fillDates() {
        this.setVisible(false);
        this.dates.clear();
        int days = this.daysInMonth(this.months.getSelectedIndex() + 1);
        for (int i = 1; i <= days; ++i) {
            this.dates.addItem(Integer.toString(i));
        }
        this.setVisible(true);
    }

    private int daysInMonth(int month) {
        switch (month) {
            case 2: {
                return 29;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    static /* synthetic */ void access$000(DatePickerPopUp x0) {
        x0.fillDates();
    }
}

