/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.place.shared.Place;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.AssetCategoryEditor;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.VersionBrowser;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;

/*
 * Exception performing whole class analysis ignored.
 */
public class MetaDataWidget
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private final Artifact artifact;
    private final boolean readOnly;
    private final String uuid;
    private VerticalPanel layout = new VerticalPanel();
    AssetCategoryEditor ed;
    private FormStyleLayout currentSection;
    private String currentSectionName;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public MetaDataWidget(ClientFactory clientFactory, EventBus eventBus, Artifact artifact, boolean readOnly, String uuid) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.uuid = uuid;
        this.artifact = artifact;
        this.readOnly = readOnly;
        this.layout.setWidth("100%");
        this.initWidget((Widget)this.layout);
        this.render();
    }

    private void render() {
        this.layout.clear();
        this.startSection(this.constants.Metadata());
        this.addHeader(images.assetVersion(), this.artifact.getName(), null);
        this.loadData();
    }

    private void addHeader(ImageResource img, String name, Image edit) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new SmallLabel("<b>" + name + "</b>"));
        if (edit != null) {
            hp.add((Widget)edit);
        }
        this.currentSection.addAttribute(this.constants.Title(), (Widget)hp);
    }

    private void loadData() {
        if (this.artifact instanceof RuleAsset) {
            this.addAttribute(this.constants.CategoriesMetaData(), this.categories());
        }
        this.addAttribute(this.constants.LastModified(), this.readOnlyDate(this.artifact.getLastModified()));
        this.addAttribute(this.constants.ModifiedByMetaData(), (Widget)this.readOnlyText(this.artifact.getLastContributor()));
        this.addAttribute(this.constants.NoteMetaData(), (Widget)this.readOnlyText(this.artifact.getCheckinComment()));
        if (!this.readOnly) {
            this.addAttribute(this.constants.CreatedOnMetaData(), this.readOnlyDate(this.artifact.getDateCreated()));
        }
        if (this.artifact instanceof RuleAsset) {
            this.addAttribute(this.constants.CreatedByMetaData(), (Widget)this.readOnlyText(((RuleAsset)this.artifact).getMetaData().getCreator()));
            this.addAttribute(this.constants.PackageMetaData(), this.packageEditor(((RuleAsset)this.artifact).getMetaData().getPackageName()));
            this.addAttribute(this.constants.IsDisabledMetaData(), this.editableBoolean((FieldBooleanBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.DisableTip()));
        }
        this.addAttribute(this.constants.FormatMetaData(), (Widget)this.readOnlyText(this.artifact.getFormat()));
        this.addAttribute("UUID:", (Widget)this.readOnlyText(this.uuid));
        this.endSection(false);
        if (this.artifact instanceof RuleAsset) {
            MetaData data = ((RuleAsset)this.artifact).getMetaData();
            this.startSection(this.constants.OtherMetaData());
            this.addAttribute(this.constants.SubjectMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.AShortDescriptionOfTheSubjectMatter()));
            this.addAttribute(this.constants.TypeMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.TypeTip()));
            this.addAttribute(this.constants.ExternalLinkMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.ExternalLinkTip()));
            this.addAttribute(this.constants.SourceMetaData(), this.editableText((FieldBinding)new /* Unavailable Anonymous Inner Class!! */, this.constants.SourceMetaDataTip()));
            this.endSection(true);
        }
        this.startSection(this.constants.VersionHistory());
        Image image = GuvnorImages.INSTANCE.Feed();
        image.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute(this.constants.VersionFeed(), (Widget)image);
        this.addAttribute(this.constants.CurrentVersionNumber(), this.getVersionNumberLabel());
        if (!this.readOnly) {
            this.addRow((Widget)new VersionBrowser(this.clientFactory, this.eventBus, this.uuid, !(this.artifact instanceof RuleAsset)));
        }
        this.endSection(true);
    }

    private void addRow(Widget widget) {
        this.currentSection.addRow(widget);
    }

    private void addAttribute(String string, Widget widget) {
        this.currentSection.addAttribute(string, widget);
    }

    private void endSection(boolean collapsed) {
        DecoratedDisclosurePanel advancedDisclosure = new DecoratedDisclosurePanel(this.currentSectionName);
        advancedDisclosure.setWidth("100%");
        advancedDisclosure.setOpen(!collapsed);
        advancedDisclosure.setContent((Widget)this.currentSection);
        this.layout.add((Widget)advancedDisclosure);
    }

    private void startSection(String name) {
        this.currentSection = new FormStyleLayout();
        this.currentSectionName = name;
    }

    private Widget packageEditor(String packageName) {
        if (this.readOnly || !UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_KNOWLEDGE_BASES_VIEW})) {
            return this.readOnlyText(packageName);
        }
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.setStyleName("metadata-Widget");
        horiz.add((Widget)this.readOnlyText(packageName));
        Image editPackage = GuvnorImages.INSTANCE.Edit();
        editPackage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horiz.add((Widget)editPackage);
        return horiz;
    }

    private void showEditPackage(String pkg, ClickEvent source) {
        FormStylePopup pop = new FormStylePopup(images.packageLarge(), this.constants.MoveThisItemToAnotherPackage());
        pop.addAttribute(this.constants.CurrentPackage(), (Widget)new Label(pkg));
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(this.constants.NewPackage(), (Widget)sel);
        Button ok = new Button(this.constants.ChangePackage());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void closeAndReopen(String newAssetUUID) {
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent((Place)new AssetEditorPlace(this.uuid)));
        this.clientFactory.getPlaceController().goTo((Place)new AssetEditorPlace(newAssetUUID));
    }

    private Widget getVersionNumberLabel() {
        if (this.artifact.getVersionNumber() == 0L) {
            return new SmallLabel(this.constants.NotCheckedInYet());
        }
        return this.readOnlyText(Long.toString(this.artifact.getVersionNumber()));
    }

    private Widget readOnlyDate(Date lastModifiedDate) {
        if (lastModifiedDate == null) {
            return null;
        }
        return new SmallLabel(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(lastModifiedDate));
    }

    private Label readOnlyText(String text) {
        SmallLabel lbl = new SmallLabel(text);
        lbl.setWidth("100%");
        return lbl;
    }

    private Widget categories() {
        this.ed = new AssetCategoryEditor(((RuleAsset)this.artifact).getMetaData(), this.readOnly);
        return this.ed;
    }

    private Widget editableBoolean(FieldBooleanBinding bind, String toolTip) {
        if (!this.readOnly) {
            CheckBox box = new CheckBox();
            box.setTitle(toolTip);
            box.setValue(Boolean.valueOf(bind.getValue()));
            9 listener = new /* Unavailable Anonymous Inner Class!! */;
            box.addClickHandler((ClickHandler)listener);
            return box;
        }
        CheckBox box = new CheckBox();
        box.setValue(Boolean.valueOf(bind.getValue()));
        box.setEnabled(false);
        return box;
    }

    private Widget editableText(FieldBinding bind, String toolTip) {
        if (!this.readOnly) {
            TextBox tbox = new TextBox();
            tbox.setTitle(toolTip);
            tbox.setText(bind.getValue());
            tbox.setVisibleLength(10);
            10 listener = new /* Unavailable Anonymous Inner Class!! */;
            tbox.addChangeHandler((ChangeHandler)listener);
            return tbox;
        }
        return new Label(bind.getValue());
    }

    public Artifact getData() {
        return this.artifact;
    }

    public void refresh() {
        this.render();
    }

    static String getVersionFeed(Artifact artifact) {
        if (artifact instanceof PackageConfigData) {
            String hurl = MetaDataWidget.getRESTBaseURL() + "packages/" + artifact.getName() + "/versions";
            return hurl;
        }
        String hurl = MetaDataWidget.getRESTBaseURL() + "packages/" + ((RuleAsset)artifact).getMetaData().getPackageName() + "/assets/" + artifact.getName() + "/versions";
        return hurl;
    }

    static String getRESTBaseURL() {
        String url = GWT.getModuleBaseURL();
        return url.replaceFirst("org.drools.guvnor.Guvnor", "rest");
    }

    static /* synthetic */ Artifact access$000(MetaDataWidget x0) {
        return x0.artifact;
    }

    static /* synthetic */ void access$100(MetaDataWidget x0, String x1, ClickEvent x2) {
        x0.showEditPackage(x1, x2);
    }

    static /* synthetic */ Constants access$200(MetaDataWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ String access$300(MetaDataWidget x0) {
        return x0.uuid;
    }

    static /* synthetic */ void access$400(MetaDataWidget x0, String x1) {
        x0.closeAndReopen(x1);
    }
}

