/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor.toolbar;

import org.drools.guvnor.client.modeldriven.ui.RuleModelEditor;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.EditorWidget;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbarButtonsConfigurationProvider;

public class DefaultActionToolbarButtonsConfigurationProvider
implements ActionToolbarButtonsConfigurationProvider {
    public static String[] VALIDATING_FORMATS = new String[]{"brl", "dslr", "xls", "drl", "enumeration", "gdst", "model.drl", "dsl", "function", "template", "springContext", "wid"};
    private static String[] SOURCE_FORMATS = new String[]{"brl", "dslr", "drl", "model.drl", "xls", "gdst", "template", "bpmn2", "bpmn"};
    public static String[] VERIFY_FORMATS = new String[]{"brl", "xls", "drl", "gdst", "model.drl", "template"};
    private RuleAsset asset;
    private EditorWidget editor;

    public DefaultActionToolbarButtonsConfigurationProvider(RuleAsset asset, EditorWidget editor) {
        this.asset = asset;
        this.editor = editor;
    }

    public boolean showSaveButton() {
        return true;
    }

    public boolean showSaveAndCloseButton() {
        return true;
    }

    public boolean showCopyButton() {
        return true;
    }

    public boolean showRenameButton() {
        return true;
    }

    public boolean showPromoteToGlobalButton() {
        return true;
    }

    public boolean showArchiveButton() {
        return this.asset.getVersionNumber() != 0L;
    }

    public boolean showDeleteButton() {
        return this.asset.getVersionNumber() == 0L;
    }

    public boolean showChangeStatusButton() {
        return true;
    }

    public boolean showSelectWorkingSetsButton() {
        return this.isValidatorTypeAsset() && this.editor instanceof RuleModelEditor;
    }

    public boolean showValidateButton() {
        return this.isValidatorTypeAsset();
    }

    public boolean showVerifyButton() {
        return this.isVerificationTypeAsset();
    }

    public boolean showViewSourceButton() {
        return this.isMemberOfFormats(this.asset.getFormat(), SOURCE_FORMATS);
    }

    public boolean showStateLabel() {
        return true;
    }

    private boolean isValidatorTypeAsset() {
        return this.isMemberOfFormats(this.asset.getFormat(), VALIDATING_FORMATS);
    }

    private boolean isVerificationTypeAsset() {
        return this.isMemberOfFormats(this.asset.getFormat(), VERIFY_FORMATS);
    }

    private boolean isMemberOfFormats(String format, String[] formats) {
        for (String fmt : formats) {
            if (!fmt.equals(format)) continue;
            return true;
        }
        return false;
    }
}

