/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DecisionTableResources;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.HasRowGroupingChangeHandlers;
import org.drools.guvnor.client.widgets.decoratedgrid.HasSelectedCellChangeHandlers;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.RowGroupingChangeEvent;
import org.drools.guvnor.client.widgets.decoratedgrid.RowGroupingChangeHandler;
import org.drools.guvnor.client.widgets.decoratedgrid.SelectedCellChangeEvent;
import org.drools.guvnor.client.widgets.decoratedgrid.SelectedCellChangeHandler;
import org.drools.guvnor.client.widgets.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.data.GroupedDynamicDataRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class MergableGridWidget<T>
extends Widget
implements ValueUpdater<Object>,
HasSelectedCellChangeHandlers,
HasRowGroupingChangeHandlers {
    protected TreeSet<CellValue<? extends Comparable<?>>> selections = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);
    protected TableElement table;
    protected TableSectionElement tbody;
    protected static final Constants messages = (Constants)GWT.create(Constants.class);
    protected static final DecisionTableResources resource = (DecisionTableResources)GWT.create(DecisionTableResources.class);
    protected static final DecisionTableResources.DecisionTableStyle style = resource.cellTableStyle();
    private static final ImageResource selectorGroupedCells = resource.collapse();
    private static final ImageResource selectorUngroupedCells = resource.expand();
    protected static final String selectorGroupedCellsHtml = MergableGridWidget.makeImageHtml((ImageResource)selectorGroupedCells);
    protected static final String selectorUngroupedCellsHtml = MergableGridWidget.makeImageHtml((ImageResource)selectorUngroupedCells);
    protected List<DynamicColumn<T>> columns = new ArrayList();
    protected DynamicData data = new DynamicData();
    protected CellValue<?> rangeOriginCell;
    protected CellValue<?> rangeExtentCell;
    protected MOVE_DIRECTION rangeDirection = MOVE_DIRECTION.NONE;
    protected boolean bDragOperationPrimed = false;

    private static native void disableTextSelectInternal(Element var0, boolean var1);

    private static String makeImageHtml(ImageResource image) {
        return AbstractImagePrototype.create((ImageResource)image).getHTML();
    }

    public MergableGridWidget() {
        style.ensureInjected();
        this.table = Document.get().createTableElement();
        this.tbody = Document.get().createTBodyElement();
        this.table.setClassName(style.cellTable());
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.setElement((Element)this.table);
        this.table.appendChild((Node)this.tbody);
        this.sinkEvents(Event.getTypeInt((String)"click") | Event.getTypeInt((String)"dblclick") | Event.getTypeInt((String)"mousedown") | Event.getTypeInt((String)"mouseup") | Event.getTypeInt((String)"mousemove") | Event.getTypeInt((String)"mouseout") | Event.getTypeInt((String)"change") | Event.getTypeInt((String)"keypress") | Event.getTypeInt((String)"keydown"));
        MergableGridWidget.disableTextSelectInternal((Element)this.table, (boolean)true);
    }

    public HandlerRegistration addRowGroupingChangeHandler(RowGroupingChangeHandler handler) {
        return this.addHandler((EventHandler)handler, RowGroupingChangeEvent.getType());
    }

    public HandlerRegistration addSelectedCellChangeHandler(SelectedCellChangeHandler handler) {
        return this.addHandler((EventHandler)handler, SelectedCellChangeEvent.getType());
    }

    public void deleteColumn(DynamicColumn<T> column, boolean bRedraw) {
        int index = this.columns.indexOf(column);
        if (index == -1) {
            throw new IllegalArgumentException("Column not found in declared columns.");
        }
        boolean bRedrawSidebar = false;
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            CellValue cv = this.data.get(iRow).get(index);
            if (!cv.isGrouped()) continue;
            this.removeModelGrouping(cv, false);
            bRedrawSidebar = true;
        }
        this.clearSelection();
        this.columns.remove(index);
        this.reindexColumns();
        this.data.deleteColumn(index);
        if (bRedraw) {
            this.redraw();
            if (bRedrawSidebar) {
                RowGroupingChangeEvent.fire((HasRowGroupingChangeHandlers)this);
            }
        }
    }

    public void deleteRow(DynamicDataRow row) {
        int index = this.data.indexOf(row);
        if (index == -1) {
            throw new IllegalArgumentException("DynamicDataRow does not exist in table data.");
        }
        this.clearSelection();
        this.data.deleteRow(index);
        if (!this.data.isMerged()) {
            this.removeRowElement(index);
        } else {
            this.removeRowElement(index);
            if (this.data.size() > 0) {
                int minRedrawRow = this.findMinRedrawRow(index - 1);
                int maxRedrawRow = this.findMaxRedrawRow(index - 1) + 1;
                if (maxRedrawRow > this.data.size() - 1) {
                    maxRedrawRow = this.data.size() - 1;
                }
                this.redrawRows(minRedrawRow, maxRedrawRow);
            }
        }
    }

    public List<DynamicColumn<T>> getColumns() {
        return this.columns;
    }

    public DynamicData getData() {
        return this.data;
    }

    public List<CellValue<?>> getSelectedCells() {
        return Collections.unmodifiableList(new ArrayList(this.selections));
    }

    public void insertColumnBefore(DynamicColumn<T> columnBefore, DynamicColumn<T> newColumn, List<CellValue<? extends Comparable<?>>> columnData, boolean bRedraw) {
        if (newColumn == null) {
            throw new IllegalArgumentException("newColumn cannot be null");
        }
        if (columnData == null) {
            throw new IllegalArgumentException("columnData cannot be null");
        }
        if (columnData.size() != this.data.size()) {
            throw new IllegalArgumentException("columnData contains a different number of rows to the grid");
        }
        int index = this.columns.size();
        if (columnBefore != null) {
            index = this.columns.indexOf(columnBefore);
            if (index == -1) {
                throw new IllegalArgumentException("columnBefore does not exist in table data.");
            }
            ++index;
        }
        this.clearSelection();
        this.columns.add(index, newColumn);
        this.reindexColumns();
        this.data.addColumn(index, columnData, newColumn.isVisible());
        if (bRedraw) {
            this.redrawColumns(index, this.columns.size() - 1);
        }
    }

    public DynamicDataRow insertRowBefore(DynamicDataRow rowBefore, List<CellValue<? extends Comparable<?>>> rowData) {
        if (rowData == null) {
            throw new IllegalArgumentException("Row data cannot be null");
        }
        if (rowData.size() != this.columns.size()) {
            throw new IllegalArgumentException("rowData contains a different number of columns to the grid");
        }
        int index = this.data.size();
        if (rowBefore != null && (index = this.data.indexOf(rowBefore)) == -1) {
            throw new IllegalArgumentException("rowBefore does not exist in table data.");
        }
        this.clearSelection();
        int minRedrawRow = index;
        int maxRedrawRow = index;
        if (this.data.isMerged()) {
            if (index < this.data.size()) {
                minRedrawRow = this.findMinRedrawRow(index);
                maxRedrawRow = this.findMaxRedrawRow(index) + 1;
            } else {
                minRedrawRow = this.findMinRedrawRow(index > 0 ? index - 1 : index);
                maxRedrawRow = index;
            }
        }
        DynamicDataRow row = this.data.addRow(index, rowData);
        if (!this.data.isMerged()) {
            this.createRowElement(index, row);
        } else {
            this.createEmptyRowElement(index);
            this.redrawRows(minRedrawRow, maxRedrawRow);
        }
        return row;
    }

    public abstract void redraw();

    public abstract void redrawColumn(int var1);

    public abstract void redrawColumns(int var1, int var2);

    public boolean toggleMerging() {
        if (!this.data.isMerged()) {
            this.clearSelection();
            this.data.setMerged(true);
            this.redraw();
        } else {
            this.clearSelection();
            this.data.setMerged(false);
            this.redraw();
            RowGroupingChangeEvent.fire((HasRowGroupingChangeHandlers)this);
        }
        return this.data.isMerged();
    }

    public void update(Object value) {
        boolean bUngroupCells = false;
        Coordinate selection = ((CellValue)this.selections.first()).getCoordinate();
        if (this.selections.size() > 1) {
            for (CellValue cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                bUngroupCells = true;
                break;
            }
        }
        for (CellValue cell : this.selections) {
            Coordinate c = cell.getCoordinate();
            if (!((DynamicColumn)this.columns.get(c.getCol())).isSystemControlled()) {
                this.data.set(c, value);
            }
            if (value == null) continue;
            cell.removeState(CellValue.CellState.OTHERWISE);
        }
        if (bUngroupCells) {
            for (CellValue cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                this.removeModelGrouping(cell, true);
            }
        }
        int baseRowIndex = ((CellValue)this.selections.first()).getCoordinate().getRow();
        int minRedrawRow = this.findMinRedrawRow(baseRowIndex);
        int maxRedrawRow = this.findMaxRedrawRow(baseRowIndex);
        if (maxRedrawRow < ((CellValue)this.selections.last()).getCoordinate().getRow()) {
            maxRedrawRow = ((CellValue)this.selections.last()).getCoordinate().getRow();
        }
        this.redrawRows(minRedrawRow, maxRedrawRow);
        this.startSelecting(selection);
    }

    private void applyModelGrouping(CellValue<?> startCell, boolean bRedraw) {
        this.data.applyModelGrouping(startCell);
        if (bRedraw) {
            int startRowIndex = startCell.getCoordinate().getRow();
            GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)this.data.get(startRowIndex);
            int minRedrawRow = this.findMinRedrawRow(startRowIndex - (startRowIndex > 0 ? 1 : 0));
            int maxRedrawRow = this.findMaxRedrawRow(startRowIndex + (startRowIndex < this.data.size() - 1 ? 1 : 0));
            for (int iRow = 0; iRow < groupedRow.getChildRows().size() - 1; ++iRow) {
                this.deleteRowElement(startRowIndex);
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
            RowGroupingChangeEvent.fire((HasRowGroupingChangeHandlers)this);
        }
    }

    private boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    private int findMaxRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int maxRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue cell = baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow < this.data.size() - 1) {
                DynamicDataRow row = this.data.get(++iRow);
                cell = row.get(iCol);
            }
            maxRedrawRow = iRow > maxRedrawRow ? iRow : maxRedrawRow;
        }
        return maxRedrawRow;
    }

    private Coordinate findMergedCellExtent(Coordinate c) {
        if (c.getRow() == this.data.size() - 1) {
            return c;
        }
        Coordinate nc = new Coordinate(c.getRow() + 1, c.getCol());
        CellValue newCell = this.data.get(nc);
        while (newCell.getRowSpan() == 0 && nc.getRow() < this.data.size() - 1) {
            nc = new Coordinate(nc.getRow() + 1, nc.getCol());
            newCell = this.data.get(nc);
        }
        if (newCell.getRowSpan() != 0) {
            nc = new Coordinate(nc.getRow() - 1, nc.getCol());
        }
        return nc;
    }

    private int findMinRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int minRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue cell = baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow > 0) {
                DynamicDataRow row = this.data.get(--iRow);
                cell = row.get(iCol);
            }
            minRedrawRow = iRow < minRedrawRow ? iRow : minRedrawRow;
        }
        return minRedrawRow;
    }

    private Coordinate getNextCell(Coordinate c, MOVE_DIRECTION dir) {
        int step = 0;
        Coordinate nc = c;
        switch (2.$SwitchMap$org$drools$guvnor$client$widgets$decoratedgrid$MergableGridWidget$MOVE_DIRECTION[dir.ordinal()]) {
            case 1: {
                int n = step = c.getCol() > 0 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow(), c.getCol() - step);
                while (nc.getCol() > 0 && !((DynamicColumn)this.columns.get(nc.getCol())).isVisible()) {
                    nc = new Coordinate(c.getRow(), nc.getCol() - step);
                }
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - 1, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case 2: {
                int n = step = c.getCol() < this.columns.size() - 1 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow(), c.getCol() + step);
                while (nc.getCol() < this.columns.size() - 2 && !((DynamicColumn)this.columns.get(nc.getCol())).isVisible()) {
                    nc = new Coordinate(c.getRow(), nc.getCol() + step);
                }
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - 1, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case 3: {
                int n = step = c.getRow() > 0 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow() - step, c.getCol());
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - step, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case 4: {
                int n = step = c.getRow() < this.data.size() - 1 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow() + step, c.getCol());
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0 && nc.getRow() < this.data.size() - 1) {
                    nc = new Coordinate(nc.getRow() + step, nc.getCol());
                    newCell = this.data.get(nc);
                }
                if (newCell.getRowSpan() != 0 || nc.getRow() != this.data.size() - 1) break;
                nc = c;
            }
        }
        return nc;
    }

    private void reindexColumns() {
        for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
            DynamicColumn col = (DynamicColumn)this.columns.get(iCol);
            col.setColumnIndex(iCol);
        }
    }

    private void removeModelGrouping(CellValue<?> startCell, boolean bRedraw) {
        List expandedRow = this.data.removeModelGrouping(startCell);
        if (bRedraw) {
            int startRowIndex;
            int minRedrawRow = this.findMinRedrawRow(startRowIndex - ((startRowIndex = startCell.getCoordinate().getRow()) > 0 ? 1 : 0));
            int maxRedrawRow = this.findMaxRedrawRow(startRowIndex + (startRowIndex < this.data.size() - 2 ? 1 : 0));
            for (int iRow = 0; iRow < expandedRow.size() - 1; ++iRow) {
                this.createEmptyRowElement(startRowIndex);
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
            RowGroupingChangeEvent.fire((HasRowGroupingChangeHandlers)this);
        }
    }

    protected void clearSelection() {
        for (CellValue cell : this.selections) {
            cell.removeState(CellValue.CellState.SELECTED);
            this.deselectCell(cell);
        }
        this.selections.clear();
        this.rangeDirection = MOVE_DIRECTION.NONE;
    }

    protected abstract void createEmptyRowElement(int var1);

    protected abstract void createRowElement(int var1, DynamicDataRow var2);

    protected abstract void deleteRowElement(int var1);

    protected boolean isGroupWidgetClicked(Event event, Element target) {
        String tagName;
        String eventType = event.getType();
        return eventType.equals("mousedown") && "img".equalsIgnoreCase(tagName = target.getTagName());
    }

    protected abstract void redrawRows(int var1, int var2);

    protected abstract void removeRowElement(int var1);

    abstract void deselectCell(CellValue<? extends Comparable<?>> var1);

    void extendSelection(Coordinate end) {
        if (this.rangeOriginCell == null) {
            throw new IllegalArgumentException("origin has not been set. Unable to extend selection");
        }
        if (end == null) {
            throw new IllegalArgumentException("end cannot be null");
        }
        this.clearSelection();
        CellValue endCell = this.data.get(end);
        this.selectRange(this.rangeOriginCell, endCell);
        if (this.rangeOriginCell.getCoordinate().getRow() > endCell.getCoordinate().getRow()) {
            this.rangeExtentCell = (CellValue)this.selections.first();
            this.rangeDirection = MOVE_DIRECTION.UP;
        } else {
            this.rangeExtentCell = (CellValue)this.selections.last();
            this.rangeDirection = MOVE_DIRECTION.DOWN;
        }
    }

    void extendSelection(MOVE_DIRECTION dir) {
        if (this.selections.size() > 0) {
            CellValue activeCell = this.rangeExtentCell == null ? this.rangeOriginCell : this.rangeExtentCell;
            Coordinate nc = this.getNextCell(activeCell.getCoordinate(), dir);
            this.clearSelection();
            this.rangeDirection = dir;
            this.rangeExtentCell = this.data.get(nc);
            this.selectRange(this.rangeOriginCell, this.rangeExtentCell);
        }
    }

    CellSelectionDetail getSelectedCellExtents(CellValue<? extends Comparable<?>> cv) {
        if (cv == null) {
            throw new IllegalArgumentException("cv cannot be null");
        }
        if (!((DynamicColumn)this.columns.get(cv.getCoordinate().getCol())).isVisible()) {
            return null;
        }
        Coordinate hc = cv.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        int offsetX = tce.getOffsetLeft();
        int offsetY = tce.getOffsetTop();
        int w = tce.getOffsetWidth();
        int h = tce.getOffsetHeight();
        CellSelectionDetail e = new CellSelectionDetail(cv.getCoordinate(), offsetX, offsetY, h, w);
        return e;
    }

    void groupCells(Coordinate start) {
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        CellValue startCell = this.data.get(start);
        if (startCell.getRowSpan() <= 1 && !startCell.isGrouped()) {
            return;
        }
        this.clearSelection();
        if (startCell.isGrouped()) {
            this.removeModelGrouping(startCell, true);
        } else {
            this.applyModelGrouping(startCell, true);
        }
    }

    abstract void hideColumn(int var1);

    void moveSelection(MOVE_DIRECTION dir) {
        if (this.selections.size() > 0) {
            CellValue activeCell = this.rangeExtentCell == null ? this.rangeOriginCell : this.rangeExtentCell;
            Coordinate nc = this.getNextCell(activeCell.getCoordinate(), dir);
            this.startSelecting(nc);
            this.rangeDirection = dir;
        }
    }

    abstract void resizeColumn(DynamicColumn<?> var1, int var2);

    abstract void selectCell(CellValue<? extends Comparable<?>> var1);

    void selectRange(CellValue<?> startCell, CellValue<?> endCell) {
        int col = startCell.getCoordinate().getCol();
        if (startCell.getCoordinate().getRow() > endCell.getCoordinate().getRow()) {
            CellValue swap = startCell;
            startCell = endCell;
            endCell = swap;
        }
        while (startCell.getRowSpan() == 0) {
            startCell = this.data.get(startCell.getCoordinate().getRow() - 1).get(col);
        }
        Coordinate nc = this.findMergedCellExtent(endCell.getCoordinate());
        endCell = this.data.get(nc);
        for (int iRow = startCell.getCoordinate().getRow(); iRow <= endCell.getCoordinate().getRow(); ++iRow) {
            CellValue cell = this.data.get(iRow).get(col);
            this.selections.add(cell);
            cell.addState(CellValue.CellState.SELECTED);
            this.selectCell(cell);
        }
        switch (2.$SwitchMap$org$drools$guvnor$client$widgets$decoratedgrid$MergableGridWidget$MOVE_DIRECTION[this.rangeDirection.ordinal()]) {
            case 4: {
                this.rangeExtentCell = (CellValue)this.selections.last();
                break;
            }
            case 3: {
                this.rangeExtentCell = (CellValue)this.selections.first();
            }
        }
    }

    abstract void showColumn(int var1);

    void startSelecting(Coordinate start) {
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        CellSelectionDetail ce = this.getSelectedCellExtents(this.data.get(start));
        SelectedCellChangeEvent.fire((HasSelectedCellChangeHandlers)this, (CellSelectionDetail)ce);
        this.clearSelection();
        CellValue startCell = this.data.get(start);
        this.selectRange(startCell, startCell);
        this.rangeOriginCell = startCell;
        this.rangeExtentCell = null;
    }
}

