/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.user.cellview.client.CellTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.drools.guvnor.client.widgets.tables.SortDirection;
import org.drools.guvnor.client.widgets.tables.SortableHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableHeaderGroup<T extends Comparable> {
    private final CellTable<T> cellTable;
    private List<SortableHeader<T, ?>> sortOrderList = new LinkedList();

    public SortableHeaderGroup(CellTable<T> cellTable) {
        this.cellTable = cellTable;
    }

    public void headerClicked(SortableHeader<T, ?> header) {
        this.updateSortOrder(header);
        this.cellTable.redrawHeaders();
        this.updateData();
    }

    private void updateSortOrder(SortableHeader<T, ?> header) {
        int index = this.sortOrderList.indexOf(header);
        if (index == 0) {
            if (header.getSortDirection() != SortDirection.ASCENDING) {
                header.setSortDirection(SortDirection.ASCENDING);
            } else {
                header.setSortDirection(SortDirection.DESCENDING);
            }
        } else {
            if (index > 0) {
                this.sortOrderList.remove(index);
            }
            header.setSortDirection(SortDirection.ASCENDING);
            this.sortOrderList.add(0, header);
            int sortIndex = 0;
            for (SortableHeader sortableHeader : this.sortOrderList) {
                sortableHeader.setSortIndex(sortIndex);
                ++sortIndex;
            }
        }
    }

    private void updateData() {
        ArrayList displayedItems = new ArrayList(this.cellTable.getDisplayedItems());
        Collections.sort(displayedItems, new /* Unavailable Anonymous Inner Class!! */);
        this.cellTable.setRowData(0, displayedItems);
        this.cellTable.redraw();
    }

    static /* synthetic */ List access$000(SortableHeaderGroup x0) {
        return x0.sortOrderList;
    }
}

